// tab4.cpp -- Display text with 4-column tabs

#include <stream.hpp>
#include <stdio.h>
#include <stdlib.h>

#define TABSTOP 5		// 5 == 4-column tabs

main(int argc, char *argv[])
{
   FILE *fp;
   char c;
   int count;

   if (argc == 1) {
      cout << "ERROR: No file name";
      exit(1);
   }
   fp = fopen(argv[1], "r");
   if (!fp) {
      cout << "ERROR: File not found";
      exit(2);
   }
   count = 1;
   while ((c = fgetc(fp)) != EOF) {
      if (c == '\t')
         while ((++count % 5) != 1) cout << ' ';
      else {
         if (c == '\n')
			   count = 1;
         else
            count++;
         cout << c;
      }
   }
   fclose(fp);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/06/1990   Time: 10:47 am
