// putln.cpp -- Add putln function to window class

#include <stream.hpp>
#include <conio.h>
#include <time.h>
#include <stdlib.h>
#include <window.h>

class window2 : public window {
   private:
      int yline;
   public:
      window2() : window() 
         { yline = 0; }
      window2(winStruct &ws, const char *title) : window(ws, title)
         { yline = 0; }
      void putln(char *s);
      void gotorc(int row, int col);
};

void fillBuffer(char *buf);

main()
{
   winStruct ws = { 4, 44, 31, 18, 0x07, 0x1f, 0x70, 3 };
   window2 *theWindow;
   char buffer[80];

   window::startup();
   theWindow = new window2(ws, " Scrolling Window ");
   theWindow->showWindow();
   while (!kbhit()) {
      fillBuffer(buffer);
      theWindow->putln(buffer);
      msleep(125);      // Remove this line for top speed
   }
   window::shutDown();
}

/* Write string and perform carriage return, line feed */
void window2::putln(char *s)
{
   winStruct ws;

   puts(s);
   ws = getInfo();
   int n = ws.height - 2;
   if (yline > n) yline = n;
   if (yline == n) {
      scrollUp(1);
      gotorc(yline, 0);
      eeol();
   } else
      gotorc(++yline, 0);
}

/* -- Replacement gotorc function */
void window2::gotorc(int row, int col)
{
   yline = row;
   window::gotorc(row, col);
}

/* -- Fill character buffer with random letters */
void fillBuffer(char *buf)
{
   for (int i = 0; i <= 20; i++)
      buf[i] = 'a' + (rand() % 26);
   buf[i] = 0;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/05/1990   Time: 06:10 pm
