// poly.cpp -- Demonstrate polymorphism

#include <stream.hpp>

/* -- Declare an abstract shape class */

class shape {
   public:
      virtual void draw(void) = 0;
};

/* -- Declare three derived classes that inherit the properties of
the shape class. */

class circle: public shape {
   public:
      virtual void draw(void);
};

class square: public shape {
   public:
      virtual void draw(void);
};

class line: public shape {
   public:
      virtual void draw(void);
};

/* -- The main program */

main()
{
   shape *p[3];            // Three shape pointers

   p[0] = new circle;      // Allocate space for a circle
   p[1] = new square;      // Allocate space for a square
   p[2] = new line;        // Allocate space for a line

/* -- Call the virtual draw method in the instance addressed by the
pointers in the p[] array. Which virtual function actually executes
is determined at runtime by the instance itself. */

   for (int i = 0; i <=2; i++)
      p[i]->draw();
}

/* -- The implementations of the three classes that derive from the
base class shape. Although declared to be virtual, the functions are
no different in form than nonvirtual member functions. */

void circle::draw(void)
{
   cout << "\nInside circle::draw()";
}

void square::draw(void)
{
   cout << "\nInside square::draw()";
}

void line::draw(void)
{
   cout << "\nInside line::draw()";
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/20/1990   Time: 03:15 pm


