// lstcount.cpp -- A list class that counts listed items

// To compile, enter:
//  ztc lstcount.cpp \lcpp\lib\item.obj \lcpp\lib\list.obj

#include <stream.hpp>
#include <item.h>
#include <list.h>

class listCount : public list {
   private:
      unsigned int itemCount;
   public:
      listCount() 
         { itemCount = 0; }
      item *insertItem(item *ip);
      item *removeItem(item *ip);
      unsigned int getCount(void) 
         { return itemCount; }
};

main()
{
   listCount *lcp = new listCount;

   cout << "\nBefore insertions count == " << lcp->getCount();
   lcp->insertItem(new item);
   lcp->insertItem(new item);
   lcp->insertItem(new item);
   cout << "\nAfter 3 insertions count == " << lcp->getCount();
   lcp->removeItem(lcp->currentItem());
   cout << "\nAfter 1 deletion count == " << lcp->getCount();
}

item * listCount::insertItem(item *ip)
{
   list::insertItem(ip);
   itemCount++;
}

item * listCount::removeItem(item *ip)
{
   list::removeItem(ip);
   itemCount--;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 12/05/1990   Time: 04:42 pm
