// error.cpp -- Error-handling module

#include <stream.hpp>
#include <stdlib.h>
#include "error.h"

int errornumber;  // Most recent error number passed to error()
int errorignore;  // 0 = halt on error; 1 = don't halt on error

/* -- Call error with error number argument. If errorignore == FALSE
(the default), program halts with error message. If errorignore ==
TRUE, then program continues and the next statement should call
geterror() to determine whether the previous operation succeeded or
failed. */

void error(int errnum, const char *s)
{
   errornumber = errnum;      // Save error number in global
   if (errorignore) return;   // Exit if not halting on errors
   if (s == NULL)             // If no string passed to function
      switch(errnum) {        // Assign literal string to s
         case ERRMEM:
            s = "Out of memory";
            break;
         case ERRWININIT:
            s = "Window class not initialized";
            break;
         default:
            s = "Unknown cause";
      }
   cout << form("\n\nERROR %d: %s\n", errnum, s);
//   cout << "\n\nERROR: " << s << '\n'; // Display message
   exit(errnum);                       // Halt program
}

/* -- Call geterror after setting errorignore to TRUE to determine
whether previous operation succeeded (geterror == 0) or failed
(geterror == 1). If the optional reset parameter == 0, then the
global errornumber is NOT reset. If you do not supply this argument
value (or if it's not 0), then the global errornumber is reset to 0.
This means that in normal use, only the first call to geterror
returns useful information. */

int geterror(int reset)
{
   int t = errornumber;

   if (reset)
      errornumber = 0;
   return t;
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/26/1990   Time: 11:31 am
