// equip.cpp -- Display list of computer's equipment

#include <stream.hpp>
#include <bios.h>

struct equipment {
   unsigned hasdiskette : 1;
   unsigned : 1;              // Not used
   unsigned planar : 2;
   unsigned videomode : 2;
   unsigned numfloppy : 2;
   unsigned : 1;              // Not used
   unsigned numserial : 3;
   unsigned gameadaptor : 1;
   unsigned : 1;              // Not used
   unsigned numprinters : 2;
};

union twotypes {
   equipment eq;     // The bit field structure
   int k;            // Same bytes as an integer
};

main()
{
   twotypes t;

   t.k = _bios_equiplist();   // Get list as integer

   cout << "\nNumber of printers          " << t.eq.numprinters;
   cout << "\nGame adaptor installed (1)  " << t.eq.gameadaptor;
   cout << "\nNumber of serial ports      " << t.eq.numserial;
   cout << "\nNumber of diskette drives   ";
   if (t.eq.hasdiskette) 
      cout << t.eq.numfloppy + 1;
   else
      cout << 0;
   cout << "\nInitial video mode (2)      " << t.eq.videomode;
   cout << "\nPlanar RAM size (3)         " << t.eq.planar;

   cout << "\n\n(1): 0=FALSE, 1=TRUE";
   cout << "\n(2): 1=40x25 color, 2=80x25 color, 3=monochrome";
   cout << "\n(3): 3=64K on XTs\n";
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/21/1990   Time: 07:55 am


