// command.h -- Header for command.cpp

#ifndef __COMMAND_H
#define __COMMAND_H  1     // Prevent multiple #includes

#include "stritem.h"

/* -- The abstract command class is an strItem with an associated
action in the form of a "pure" virtual function. Selecting a command
object derived from the command class calls the derived virtual
function. With this design, all commands are objects, eliminating the
need for the large switch statements typically found in menu-driven
programs. */

class command : public strItem {
   protected:
      int cmdNum;    // Unique number to identify command
   public:
      command(const char *s, int cn = 0) : strItem(s) { cmdNum = cn; }
      virtual void performCommand(void) = 0;
};

#endif   // __COMMAND_H


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/25/1990   Time: 08:52 am
