// center.cpp -- Center text on screen

#include <stream.hpp>
#include <stdio.h>
#include <disp.h>
#include <string.h>

void center(int row, int col, char *s, int width = 0, int fill = '-');

char s[128];      // String to center

main()
{
   int length;    // Length of string

// Prompt for a string to center
   cout << "Enter a string: ";
   gets(s);
   length = strlen(s);     // Get length of string

// Prepare display 
   disp_open();
   disp_move(0, 0);
   disp_eeop();

// Display string using all defaults
   center(10, 40, s);

// Display string with only fill default
   center(12, 40, s, length + 8);

// Display string with no defaults
   center(14, 40, s, length + 16, '*');

   disp_move(24, 0);
   disp_close();
}

void center(int row, int col, char *s, int width, int fill)
{
   int wd2;    // Width divided by 2
   int c;      // for-loop control variable

   if (width > 0) {
      wd2 = width / 2;
      for (c = col - wd2; c <= col + wd2; c++)
         disp_pokew(row, c, (DISP_NORMAL * 256) + fill);
   }
   disp_move(row, col - (strlen(s) / 2));
   disp_printf(s);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 08/23/1990   Time: 11:11 am


