// bp.cpp -- Count braces and parentheses in C++ programs

#include <stream.hpp>
#include <stdio.h>
#include <stdlib.h>

void welcome(void);
void openfile(void);
void countchars(char c);
void showresults(void);

int openparen, closeparen, openbrace, closebrace;
char filename[128];
FILE *fp;

main()
{
   char c;

   welcome();
   openfile();
   while ((c = fgetc(fp)) != EOF)
      countchars(c);
   showresults();
   fclose(fp);
}

void welcome(void)
{
   cout << "\n\nBraces and Parentheses Counter";
   cout << "\nby Tom Swan.\n";
}

void openfile(void)
{
   cout << "\nFile name? ";
   gets(filename);
   fp = fopen(filename, "r");    // Open file for reading
   if (!fp) {
      cout <<"\nError opening file\n";
      exit(1);
   }
}

void countchars(char c)
{
   if (c == '(') openparen++;
   else if (c == ')') closeparen++;
   else if (c == '{') openbrace++;
   else if (c == '}') closebrace++;
}

void showresults(void)
{
   if (openparen < closeparen)
      cout << "\nMissing " << (closeparen - openparen) 
           << " ( character(s)";
   else if (openparen > closeparen)
      cout << "\nMissing " << (openparen - closeparen) 
           << " ) character(s)";
   else
      cout << "\nParentheses match";

   if (openbrace < closebrace)
      cout << "\nMissing " << (closebrace - openbrace) 
           << " { character(s)";
   else if (openbrace > closebrace)
      cout << "\nMissing " << (openbrace - closebrace) 
           << " } character(s)";
   else
      cout << "\nBraces match";

   cout << "\n\n";
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/05/1990   Time: 08:30 am

