// bitdate.cpp -- Pack date and time in a bit-field struct

#include <stream.hpp>

struct dnt {
   char month, day;
   int year;
   char hour, minute, second;
};

struct packdnt {
   unsigned month  : 4;    // 0 .. 11 (max == 15)
   unsigned day    : 5;    // 1 .. 31 (max == 31)
   unsigned year   : 6;    // 0 .. 59 (assume base = 1980)
   unsigned hour   : 5;    // 0 .. 23 (max = 31)
   unsigned minute : 6;    // 0 .. 59 (max = 63)
//   unsigned second : 6;    // 0 .. 59 (max = 63)
};

main()
{
   dnt regular;
   packdnt compressed;

   cout << "Size of regular dnt = " << sizeof(regular);
   cout << "\nSize of packed dnt = " << sizeof(compressed);
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/24/1990   Time: 09:24 am
