// words.cpp -- Count words in standard input

#include <stream.hpp>
#include <ctype.h>

main()
{
   char c;
   int words, chars, lines, insideWord;
   
   words = chars = lines = insideWord = 0;

   while ((c = getchar()) != EOF) {
      chars++;
      if (c == '\n') {
         lines++; 
         chars++;
      }
      if (insideWord)
         insideWord = !isspace(c);
      else {
         insideWord = !isspace(c);
         if (insideWord) 
            words++;
      }
   }

   cout << chars << " total character(s)\n";
   cout << words << " word(s)\n";
   cout << lines << " line(s)\n";
}


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 10/02/1990   Time: 10:53 am
