// wintool.h -- Header for wintool.cpp

#include "key.h"
#include "command.h"
#include "window.h"
#include "selector.h"

/* -- Pop-up menu position, size, and other attributes */

#define MENU_ROW        4
#define MENU_COL        5
#define MENU_WIDTH      24
#define MENU_HEIGHT     9
#define MENU_TA         0x07
#define MENU_BA         0x1f
#define MENU_HA         0x70
#define MENU_TYPE       1           // Single-line border
#define MENU_TITLE      " Menu "
#define MENU_POPUP      0           // Not pop-up, stationary

/* -- Sample window position, size, and other attributes */

#define SAMP_ROW        4
#define SAMP_COL        44
#define SAMP_WIDTH      31
#define SAMP_HEIGHT     18
#define SAMP_TYPE       3
#define SAMP_TITLE      " Sample Window "

/* -- Unique values identifying menu commands that call
the same command-object virtual function. That function uses
these values to determine which command called it. */

#define CMD_TBG   0
#define CMD_TFG   1
#define CMD_BBG   2
#define CMD_BFG   3
#define CMD_HBG   4
#define CMD_HFG   5

/* -- Command classes for WinTool */

class helpCommand : public command {
   public:
      helpCommand() : command(" Help") { }
      virtual void performCommand(void);
};

class attrCommand : public command {
   public:
      attrCommand(const char *s, int cn) : command(s, cn) { }
      virtual void performCommand(void);
};

/* -- Function prototypes for main program */

void createMainWindow(void);
void createSampWindow(void);
void performCommands(void);
void showColors(void);
void showSample(void);


// Copyright (c) 1990 by Tom Swan. All rights reserved
// Revision 1.00    Date: 09/28/1990   Time: 03:21 pm
