
/************
* Check Box
************/

#define BM_SETPICT               (WM_USER + 51)

#define BT_NONE                  0x0000
#define BT_ICON                  0x0001
#define BT_BITMAP                0x0002
#define BT_HANDLE                0x0004
#define BT_PICT_UP               0x0010
#define BT_PICT_DOWN             0x0020
#define BT_PICT_FOCUSUP          0x0040
#define BT_PICT_FOCUSDOWN        0x0080
#define BT_PICT_DISABLEDUP       0x0100
#define BT_PICT_DISABLEDDOWN     0x0200

/***********
* SuperBtn
***********/

#define SBS_DEFPUSHBUTTON        0x0001L
#define SBS_TEXTTOP_PICTBOT      0x0002L
#define SBS_TEXTBOT_PICTTOP      0x0004L
#define SBS_TEXTLEFT_PICTRIGHT   0x0008L
#define SBS_TEXTRIGHT_PICTLEFT   0x0010L
#define SBS_BTNFRAMEIN           0x0020L
#define SBS_BTNFRAMEOUT          0x0040L
#define SBS_PICTFRAMEIN          0x0080L
#define SBS_PICTFRAMEOUT         0x0100L
#define SBS_TEXTFRAMEIN          0x0200L
#define SBS_TEXTFRAMEOUT         0x0400L
#define SBS_NOINVERTFRAME        0x0800L
#define SBS_TEXTICON             0x1000L
#define SBS_TEXTBITMAP           0x2000L
#define SBS_TEXTTEXT             0x4000L
#define SBS_NOPOINTERFOCUS       0x8000L

#define SBM_SETSTYLE             BM_SETSTYLE
#define SBM_SETCOLOR             (WM_USER + 50)
#define SBM_SETPICT              BM_SETPICT
#define SBM_SETPICT_DISABLED     (WM_USER + 52)
#define SBM_SETPICT_BTNDOWN      (WM_USER + 53)
#define SBM_GETCOLOR             (WM_USER + 54)
#define SBM_SETBUTTONTYPE        (WM_USER + 55)
#define SBM_GETBUTTONSTATE       (WM_USER + 56)
#define SBM_SETBUTTONSTATE       (WM_USER + 57)
#define SBM_SETSHADOWSIZE        (WM_USER + 58)
#define SBM_GETSHADOWSIZE        (WM_USER + 59)

#define SBN_CLICKED              BN_CLICKED

#define SUPERBTN_UP              0
#define SUPERBTN_DOWN            1

#define SUPERBTN_TYPE_NORMAL     0
#define SUPERBTN_TYPE_2STATE     1

#define SUPERBTN_PICT_NONE       0
#define SUPERBTN_PICT_ICON       BT_ICON
#define SUPERBTN_PICT_BITMAP     BT_BITMAP
#define SUPERBTN_PICT_HANDLE     BT_HANDLE

typedef struct superbtncolor
   {
   COLORREF Color;
   COLORREF ColorBorder;
   COLORREF ColorShadow;
   COLORREF ColorHighlight;
   COLORREF ColorText;
   } SUPERBTNCOLOR, FAR *LPSUPERBTNCOLOR;

/**********
* ToolBox
**********/

#define TBXS_SINGLESEL    0x01L
#define TBXS_MULTISEL     0x02L
#define TBXS_NOSTATE      0x04L

#define TBX_NOSEL         0
#define TBX_SELECTED      1
#define TBX_DISABLED      2

#define TBX_RESIZE        -1
#define TBX_MAXSIZE       -2

#define TBXM_SETCOLOR     (WM_USER + 50)
#define TBXM_GETCOLOR     (WM_USER + 51)
#define TBXM_GETITEMSTATE (WM_USER + 52)
#define TBXM_SETITEMSTATE (WM_USER + 53)
#define TBXM_GETITEMCNT   (WM_USER + 54)
#define TBXM_ADDITEM      (WM_USER + 55)
#define TBXM_INSERTITEM   (WM_USER + 56)
#define TBXM_DELETEITEM   (WM_USER + 57)

#define TBXN_CLICKED      1

typedef struct toolboxcolor
   {
   COLORREF Background;
   COLORREF Border;
   COLORREF ButtonBorder;
   COLORREF ButtonUpColor;
   COLORREF ButtonUpShadow;
   COLORREF ButtonUpHighlight;
   COLORREF ButtonUpText;
   COLORREF ButtonDownColor;
   COLORREF ButtonDownShadow;
   COLORREF ButtonDownHighlight;
   COLORREF ButtonDownText;
   } TOOLBOXCOLOR, FAR *LPTOOLBOXCOLOR;

typedef struct toolboxitem
   {
   short Id;
   LPSTR lpPictUpName;
   short dPictUpType;
   LPSTR lpPictDownName;
   short dPictDownType;
   LPSTR lpPictDisabledName;
   short dPictDisabledType;
   LPSTR lpText;
   short dColWidth;
   short dRowHeight;
   long  lStyle;
   } TOOLBOXITEM, FAR *LPTOOLBOXITEM;

/************
* StatusBar
************/

#define SBRS_TEXTLEFT         0x0001
#define SBRS_TEXTCENTER       0x0002
#define SBRS_TEXTRIGHT        0x0004
#define SBRS_DRAWTOPLINE      0x0008
#define SBRS_PROGRESS         0x0010
#define SBRS_PIXELS           0x0020
#define SBRS_PERCENTSCREEN    0x0040
#define SBRS_PERCENT          0x0080
#define SBRS_TWIPS            0x0100
#define SBRS_DLGUNITS         0x0200
#define SBRS_OWNERDRAW        0x0400

#define SBRM_SETCOLOR         (WM_USER + 50)
#define SBRM_GETCOLOR         (WM_USER + 51)
#define SBRM_SETITEMS         (WM_USER + 52)
#define SBRM_SETITEMTEXT      (WM_USER + 53)
#define SBRM_GETITEMTEXT      (WM_USER + 54)
#define SBRM_GETITEMRECT      (WM_USER + 55)
#define SBRM_SETPROGRESSPOS   (WM_USER + 56)
#define SBRM_SETPROGRESSRANGE (WM_USER + 57)

#define SBR_AUTOSIZE          -1

#define ODT_TBSTATUSBAR       500

typedef struct statusbarcolor
   {
   COLORREF Line;
   COLORREF Background;
   COLORREF Shadow;
   COLORREF Highlight;
   COLORREF Text;
   COLORREF Progress;
   } STATUSBARCOLOR, FAR *LPSTATUSBARCOLOR;

typedef struct statusbarprogress
   {
   short dMin;
   short dMax;
   BOOL  fShowPercentage;
   } STATUSBARPROGRESS, FAR *LPSTATUSBARPROGRESS;

typedef struct statusbaritem
   {
   WORD  ItemID;
   long  lOffset;
   long  lWidth;
   LPSTR lpText;
   long  lItemStyle;
   } STATUSBARITEM, FAR *LPSTATUSBARITEM;

