/************************************************************************

	Software:	LCKOWL.DLL

	Version:	1.00
			Copyright by Larry Klein, LCK Consulting, December 7, 1992

	Developed By:	Larry Klein
			LCK Consulting
			732 Symphony Woods Drive
			Silver Spring, MD  20901
			Phone - 301-593-2745
			Fax   - 301-593-4262
			Compuserve - 76330,2525

	Purpose:	BC++ OWL MDI Frame class that automatically manages
			a status bar, tool bar and toolbox.

	Requirements:	Borland C++ Compiler 3.0 or higher
			LCKUtil.DLL for error message handling
			Drover's Toolbox by Farpoint
				FarPoint Technologies
				P.O. Box 309
				75 Walnut Street
				Richmond, Ohio  43944-0309
				Phone: 614-765-4333
				Fax:   614-765-4939

************************************************************************/

#include "windows.h"
extern "C" {
#include "toolbox.h"
}
#include "lckowl.h"

char		szAppName[] = "LCK OWL Extension";

PTModule 	TheModule;


TMDIFrameTools::TMDIFrameTools(LPSTR ATitle, LPSTR MenuName)
	: TMDIFrame(ATitle, MenuName)
{
	StatusBar = NULL;
	ToolBar = NULL;
};

TMDIFrameTools::~TMDIFrameTools()
{
	if(StatusBar) delete StatusBar;
	if(ToolBar) delete ToolBar;
}

void	TMDIFrameTools::CMCreateStatusBar(RTMessage)
{
	if( StatusBar && !StatusBar->Exists() ) {
		StatusBar->Create(HWindow);
		Resize();
	}
}

void	TMDIFrameTools::CMCreateToolBar(RTMessage)
{
	if( ToolBar && !ToolBar->Exists() ) {
		ToolBar->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void	TMDIFrameTools::CMCreateToolBox(RTMessage)
{
	if( ToolBox && !ToolBox->Exists() ) {
		ToolBox->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyStatusBar(RTMessage)
{
	if( StatusBar && StatusBar->Exists() ) {
		StatusBar->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyToolBar(RTMessage)
{
	if( ToolBar && ToolBar->Exists() ) {
		ToolBar->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyToolBox(RTMessage)
{
	if( ToolBox && ToolBox->Exists() ) {
		ToolBox->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMToggleStatusBar(RTMessage)
{
	HMENU	hMenu;

	if ( !StatusBar ) return; 	// Must first initialize status bar

	hMenu = GetMenu(HWindow);

	if ( StatusBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_UNCHECKED);
		StatusBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_CHECKED);
		StatusBar->Create(HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TMDIFrameTools::CMToggleToolBar(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBar ) return; 	// Must first initialize tool bar

	hMenu = GetMenu(HWindow);

	if ( ToolBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_CHECKED);
		ToolBar->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TMDIFrameTools::CMToggleToolBox(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBox ) return; 	// Must first initialize tool bar

	hMenu = GetMenu(HWindow);

	if ( ToolBox->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBox->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_CHECKED);
		ToolBox->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void CALLBACK TMDIFrameTools::InitStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight, DWORD AStyle)
{
 	StatusBar = new TLCKStatusBar(AStatusBar, AItems, AHeight, AStyle);
}

void CALLBACK TMDIFrameTools::InitToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBar = new TLCKToolBar(AToolBar, AItems, AHeight, AWidth, AStyle);
}

void CALLBACK TMDIFrameTools::InitToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle, int AColumns, int ARows, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBox = new TLCKToolBox(AToolBox, AItems, ATitle, AColumns, ARows, AHeight, AWidth, AStyle);
}

void 	TMDIFrameTools::Resize()
{
	RECT	Rect;
	int	nClientTopOffset, nClientBottomOffset;

	if( IsIconic(HWindow) ) return;	// can't resize icon!

	nClientTopOffset = nClientBottomOffset = 0;
	 
	if( ToolBar && ToolBar->Exists() ) {
		nClientTopOffset += ToolBar->nHeight + 2;
		nClientBottomOffset += ToolBar->nHeight + 2;
	}
	if( StatusBar && StatusBar->Exists() ) nClientBottomOffset += StatusBar->nHeight;

	GetClientRect(HWindow, &Rect);
	MoveWindow(ClientWnd->HWindow, 0, nClientTopOffset, Rect.right,
		 Rect.bottom - nClientBottomOffset, TRUE);
	if( StatusBar && StatusBar->Exists() ) MoveWindow(StatusBar->HWindow, 0, Rect.bottom - StatusBar->nHeight,
				Rect.right, StatusBar->nHeight, TRUE);

}

void 	TMDIFrameTools::WMCommand(RTMessage Msg)
{
        TMDIFrame::WMCommand(Msg);

	// This will convert toolbar/box button clicks to menu commands
	// if the button IDs match menu IDs

	if(Msg.LP.Hi == TBXN_CLICKED)	
		PostMessage(HWindow, WM_COMMAND, Msg.WParam, 0L);
}

void 	TMDIFrameTools::WMSize(RTMessage Msg)
{
	TMDIFrame::WMSize(Msg);
	Resize();
}

TLCKStatusBar::TLCKStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight, DWORD AStyle)
{
	HWindow = NULL;
	Style = AStyle;
	nHeight = AHeight;
	nItems = AItems;
	StatusBar = new STATUSBARITEM[nItems];
	if(!StatusBar) LCKMessage(LCKERR_CANTALLOCATE);
        else MemCpy(StatusBar, AStatusBar, nItems * sizeof(STATUSBARITEM));
}

TLCKStatusBar::~TLCKStatusBar()
{
	delete StatusBar;
}

HWND CALLBACK TLCKStatusBar::Create(HWND AWindow)
{
	RECT		RectClient;

	if(!nHeight) {
		HDC hdc = GetDC(AWindow);
		TEXTMETRIC tm;
		GetTextMetrics(hdc, &tm);
		nHeight = tm.tmHeight + tm.tmExternalLeading + 2;
		ReleaseDC(AWindow, hdc);
        }

	GetClientRect(AWindow, &RectClient);
	HWindow = tbCreateStatusBar(AWindow, WS_CHILD | WS_VISIBLE | SBRS_DRAWTOPLINE |
			    SBRS_PIXELS, 0,
                            RectClient.bottom - nHeight,
			    RectClient.right, nHeight,
			    StatusBar, nItems);

        return HWindow;
}

void CALLBACK TLCKStatusBar::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYSTATUSBAR);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

void CALLBACK TLCKStatusBar::SetItemText(WORD AItem, LPSTR AText)
{
	SendMessage(HWindow, SBRM_SETITEMTEXT, AItem, (LONG) AText);
}

void CALLBACK TLCKStatusBar::SetProgressPos(WORD AItem, WORD APos)
{
	SendMessage(HWindow, SBRM_SETPROGRESSPOS, AItem, (LONG) APos);
}

void CALLBACK TLCKStatusBar::SetProgressRange(WORD AItem, WORD AMinimum, WORD AMaximum)
{
	SendMessage(HWindow, SBRM_SETPROGRESSRANGE, AItem, MAKELONG(AMinimum, AMaximum));
}

TLCKToolBar::TLCKToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight, int AWidth, DWORD AStyle)
{
	HWindow = NULL;
	Style = AStyle;
	nHeight = AHeight;
        nWidth = AWidth;
	nItems = AItems;
	x = y = 0;
	dColCount = TBX_MAXSIZE;
	dRowCount = 1;
	dBorderSize = 0;
	ToolBar = new TOOLBOXITEM[nItems];
	if(!ToolBar) LCKMessage(LCKERR_CANTALLOCATE);
	else MemCpy(ToolBar, AToolBar, nItems * sizeof(TOOLBOXITEM));
}

TLCKToolBar::~TLCKToolBar()
{
	delete ToolBar;
}

HWND CALLBACK TLCKToolBar::Create(HINSTANCE AInst, HWND AWindow)
{
	int	i;

	HWindow = tbCreateToolBox(AInst, AWindow, Style, x, y, nWidth, nHeight,
			 dColCount, dRowCount, dBorderSize, NULL);

	for (i = 0; i < nItems; i++)
		SendMessage(HWindow, TBXM_ADDITEM, 0, (long)(LPSTR)&ToolBar[i]);

        return HWindow;
}

void CALLBACK TLCKToolBar::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYTOOLBAR);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

TLCKToolBox::TLCKToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle, int AColumns, int ARows, int AHeight, int AWidth, DWORD AStyle)
{
	HWindow = NULL;
        if(ATitle) {
		strncpy(Title, ATitle, LCK_MAXLEN_TITLE);
		Title[LCK_MAXLEN_TITLE - 1] = NULL;
	}
	else *Title = NULL;
	Style = AStyle;
	nHeight = AHeight;
        nWidth = AWidth;
	nItems = AItems;
	x = y = 0;
	dColCount = AColumns;
	dRowCount = ARows;
	dBorderSize = 0;
	ToolBox = new TOOLBOXITEM[nItems];
	if(!ToolBox) LCKMessage(LCKERR_CANTALLOCATE);
	else MemCpy(ToolBox, AToolBox, nItems * sizeof(TOOLBOXITEM));
}

TLCKToolBox::~TLCKToolBox()
{
	delete ToolBox;
}

HWND CALLBACK TLCKToolBox::Create(HINSTANCE AInst, HWND AWindow)
{
	int	i;

	HWindow = tbCreateToolBox(AInst, AWindow, Style, x, y, nWidth, nHeight,
			 dColCount, dRowCount, dBorderSize, *Title ? Title : NULL);

	for (i = 0; i < nItems; i++)
		SendMessage(HWindow, TBXM_ADDITEM, 0, (long)(LPSTR)&ToolBox[i]);

        return HWindow;
}

void CALLBACK TLCKToolBox::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYTOOLBOX);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

int FAR PASCAL LibMain(HANDLE hInstance, WORD /*wDataSeg*/,
  WORD /* cbHeapSize */, LPSTR lpCmdLine)
{
	int TheStatus;

	TheModule = new TModule("LCKOWL", hInstance, lpCmdLine);
	TheStatus = TheModule->Status;
	if ( TheStatus != 0 ) {
		delete TheModule;
		TheModule = NULL;
	}

	return (TheStatus == 0);
}

int FAR PASCAL WEP(int /*bSystemExit*/)
{
//	if ( TheModule ) delete TheModule;
	return 1;
}

