#include "genmdix.h"

char	szAppName[] = 	"MDI Application With Tools";

static STATUSBARPROGRESS ProgressItem[] = {
	0, 100, TRUE,
};

static STATUSBARITEM StatusBarItems[] = {
	100, 8, SBR_AUTOSIZE, "", SBRS_TEXTLEFT,
	101, 8, SBR_AUTOSIZE, (LPSTR) &ProgressItem[0], SBRS_PROGRESS,
};

#define NUM_STATUSBARITEMS ((sizeof(StatusBarItems)) / sizeof(STATUSBARITEM))

static TOOLBOXITEM ToolBarItems[] =
   {
   IDM_NEW, "New",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER1, "BM1",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER2, "BM2",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
};

#define NUM_TOOLBARITEMS ((sizeof(ToolBarItems)) / sizeof(TOOLBOXITEM))

// I have used four rows of three buttons that repeat

static TOOLBOXITEM ToolBoxItems[] =
   {
   IDM_NEW, "New",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER1, "BM1",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER2, "BM2",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_NEW, "New",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER1, "BM1",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER2, "BM2",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_NEW, "New",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER1, "BM1",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER2, "BM2",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_NEW, "New",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER1, "BM1",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
   IDM_ENTER2, "BM2",   SUPERBTN_PICT_BITMAP, NULL, 0, NULL, 0,
                      NULL, 1, 1, 0L,
};

#define NUM_TOOLBOXITEMS ((sizeof(ToolBoxItems)) / sizeof(TOOLBOXITEM))

void 	TGENApp::InitMainWindow()
{
	MainWindow = new TGENMDIFrame(szAppName, "MainMenu");
}

TGENMDIFrame::TGENMDIFrame(LPSTR ATitle, LPSTR MenuName)
	     : TMDIFrameTools(ATitle, MenuName)
{
	ChildMenuPos = 2;
	InitStatusBar(StatusBarItems, NUM_STATUSBARITEMS);
	InitToolBar(ToolBarItems, NUM_TOOLBARITEMS);
	InitToolBox(ToolBoxItems, NUM_TOOLBOXITEMS, "ToolBox", NUM_TOOLBOXITEMS/4, NUM_TOOLBOXITEMS/3);
}

void	TGENMDIFrame::CMEnter1(RTMessage)
{
	char	szText[30];

	szText[0] = NULL;
	if( GetApplication()->ExecDialog(new TInputDialog(this, "First Status Bar Window", "Enter Text:",
			szText, sizeof(szText))) == IDOK ) {
		StatusBar->SetItemText(100, szText);
	} 
}

void	TGENMDIFrame::CMEnter2(RTMessage)
{
	char	szText[30];

	szText[0] = NULL;
	if( GetApplication()->ExecDialog(new TInputDialog(this, "First Status Bar Window", "Enter Text:",
			szText, sizeof(szText))) == IDOK ) {
		StatusBar->SetProgressPos(101, atoi(szText));
	} 
}

void	TGENMDIFrame::CMNew(RTMessage)
{
	GetApplication()->MakeWindow(new TWindow(this, "Test"));
}

void 	TGENMDIFrame::SetupWindow()
{
	TMDIFrameTools::SetupWindow();
//	StatusBar->Create(HWindow);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmd, int nCmdShow)
{
	TGENApp GENApp (szAppName, hInstance, hPrevInstance, lpCmd, nCmdShow);
	GENApp.Run();
	return (GENApp.Status);
}


