/************************************************************************

	Software:	LCKOWL.DLL

	Version:	1.00
			Copyright by Larry Klein, LCK Consulting, December 7, 1992

	Developed By:	Larry Klein
			LCK Consulting
			732 Symphony Woods Drive
			Silver Spring, MD  20901
			Phone - 301-593-2745
			Fax   - 301-593-4262
			Compuserve - 76330,2525

	Purpose:	BC++ OWL MDI Frame class that automatically manages
			a status bar, tool bar and toolbox.

	Requirements:	Borland C++ Compiler 3.0 or higher
			LCKUtil.DLL for error message handling
			Drover's Toolbox by Farpoint
				FarPoint Technologies
				P.O. Box 309
				75 Walnut Street
				Richmond, Ohio  43944-0309
				Phone: 614-765-4333
				Fax:   614-765-4939

************************************************************************/

#include "string.h"
#include "owl.h"
#include "mdi.h"
#include "lckowl2.h"
#include "lckutil.h"

#ifndef __LCKOWL_H__
#define __LCKOWL_H__

#define TOOLBAR_WIDTH          	32
#define TOOLBAR_HEIGHT         	32

#define LCK_MAXLEN_TITLE	32

_CLASSDEF(TMDIFrameTools)
_CLASSDEF(TLCKStatusBar)
_CLASSDEF(TLCKToolBar)
_CLASSDEF(TLCKToolBox)

class _EXPORT TLCKWindowTools
{
    protected:

    public:
	TLCKWindowTools() {};
	void FAR PASCAL CMNew() = [CM_FIRST + 101]
		{ MessageBox(GetFocus(), "TEST", NULL, MB_OK); };
};

class _EXPORT TMDIFrameTools : public TMDIFrame
{
    protected:
	PTLCKStatusBar	StatusBar;
	PTLCKToolBar	ToolBar;
	PTLCKToolBox	ToolBox;

    public:
	TMDIFrameTools(LPSTR ATitle, LPSTR MenuName);
	~TMDIFrameTools();
	virtual void	CMCreateStatusBar(RTMessage Msg)	= [CM_FIRST + IDM_CREATESTATUSBAR];
	virtual void	CMCreateToolBar(RTMessage Msg)		= [CM_FIRST + IDM_CREATETOOLBAR];
	virtual void	CMCreateToolBox(RTMessage Msg)		= [CM_FIRST + IDM_CREATETOOLBOX];
	virtual void	CMDestroyStatusBar(RTMessage Msg)	= [CM_FIRST + IDM_DESTROYSTATUSBAR];
	virtual void	CMDestroyToolBar(RTMessage Msg)		= [CM_FIRST + IDM_DESTROYTOOLBAR];
	virtual void	CMDestroyToolBox(RTMessage Msg)		= [CM_FIRST + IDM_DESTROYTOOLBOX];
	virtual void	CMToggleStatusBar(RTMessage Msg)	= [CM_FIRST + IDM_TOGGLESTATUSBAR];
	virtual void	CMToggleToolBar(RTMessage Msg)		= [CM_FIRST + IDM_TOGGLETOOLBAR];
	virtual void	CMToggleToolBox(RTMessage Msg)		= [CM_FIRST + IDM_TOGGLETOOLBOX];
	void CALLBACK	InitStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight = NULL,
				DWORD AStyle = WS_CHILD | WS_VISIBLE | SBRS_DRAWTOPLINE | SBRS_PIXELS);
	void CALLBACK	InitToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight = TOOLBAR_HEIGHT, int AWidth = TOOLBAR_WIDTH,
				DWORD AStyle = WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE | WS_BORDER | TBXS_NOSTATE);
	void CALLBACK	InitToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle = NULL, int AColumns = TBX_RESIZE,
			int ARows = 1, int AHeight = TOOLBAR_HEIGHT, int AWidth = TOOLBAR_WIDTH,
			DWORD AStyle = WS_CLIPSIBLINGS | WS_VISIBLE | WS_BORDER | WS_CAPTION | TBXS_SINGLESEL);
	void 		Resize();
	virtual void	WMCommand(RTMessage Msg)		= [WM_FIRST + WM_COMMAND];
	virtual void	WMSize(RTMessage Msg)			= [WM_FIRST + WM_SIZE];
};

class _EXPORT TLCKStatusBar
{
    protected:
	int		nItems;
	DWORD		Style;
	LPSTATUSBARITEM	StatusBar;

    public:
	HWND		HWindow;
	int		nHeight;

	TLCKStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight = NULL,
			DWORD AStyle = WS_CHILD | WS_VISIBLE | SBRS_DRAWTOPLINE | SBRS_PIXELS);
	~TLCKStatusBar();
	HWND CALLBACK	Create(HWND AWindow);
	void CALLBACK	Destroy();
	BOOL CALLBACK	Exists() { return HWindow == NULL ? FALSE : TRUE; };
	void CALLBACK	SetItemText(WORD AItem, LPSTR AText);
	void CALLBACK	SetProgressPos(WORD AItem, WORD APos);
        void CALLBACK	SetProgressRange(WORD AItem, WORD AMinimum, WORD AMaximum);
};

class _EXPORT TLCKToolBar
{
    protected:
	int		nItems;
	DWORD		Style;
	LPTOOLBOXITEM	ToolBar;
	short		x, y, dColCount, dRowCount, dBorderSize;

    public:
	HWND		HWindow;
	int		nHeight;
	int		nWidth;

	TLCKToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight = TOOLBAR_HEIGHT, int AWidth = TOOLBAR_WIDTH,
			DWORD AStyle = WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE | WS_BORDER | TBXS_NOSTATE);
	~TLCKToolBar();
	HWND CALLBACK	Create(HINSTANCE AInst, HWND AWindow);
	void CALLBACK	Destroy();
	BOOL CALLBACK	Exists() { return HWindow == NULL ? FALSE : TRUE; };
};

class _EXPORT TLCKToolBox
{
    protected:
	char		Title[LCK_MAXLEN_TITLE];
	int		nItems;
	DWORD		Style;
	LPTOOLBOXITEM	ToolBox;
	short		x, y, dColCount, dRowCount, dBorderSize;

    public:
	HWND		HWindow;
	int		nHeight;
	int		nWidth;

	TLCKToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle = NULL, int AColumns = TBX_RESIZE,
			int ARows = 1, int AHeight = TOOLBAR_HEIGHT, int AWidth = TOOLBAR_WIDTH,
			DWORD AStyle = WS_CLIPSIBLINGS | WS_VISIBLE | WS_BORDER | WS_CAPTION | TBXS_SINGLESEL);
	~TLCKToolBox();
	HWND CALLBACK	Create(HINSTANCE AInst, HWND AWindow);
	void CALLBACK	Destroy();
	BOOL CALLBACK	Exists() { return HWindow == NULL ? FALSE : TRUE; };
};

#endif // __LCKOWL_H__
