// LANTEST.H -- Defines for LANTEST
// Copyright (c) 1994 by Allen Brunson  version 1.00  06/30/94

#ifdef _MSC_VER                  // If a Microsoft compiler
#pragma warning (disable:4018)   // Disable erroneous signed/unsigned warning
#ifndef M_I86SM                  // If not small model
#error LANTEST designed for the SMALL memory model
#endif
#endif

#ifdef __TURBOC__                // If a Borland compiler
#ifndef __SMALL__                // If not small model
#error LANTEST designed for the SMALL memory model
#endif
#endif

#include "lanlib.h"              // LANLIB defines
#include "lancfg.h"              // LANLIB configuration defines


/****************************************************************************/
/*                                                                          */
/***  General definitions                                                 ***/
/*                                                                          */
/****************************************************************************/

#ifndef  TRUEFALSE                                 // If TRUEFALSE not set
#define  TRUEFALSE                                 // Define it
#define  FALSE               0                     // Boolean false
#define  OFF                 0                     //  defines
#define  NO                  0
#define  TRUE                1                     // Boolean true
#define  ON                  1                     //  defines
#define  YES                 1
#endif

#ifndef  BYTE                                      // If BYTE not yet defined
#define  BYTE                                      // Set definition
typedef  unsigned char byte;                       // Typedef byte type
#endif
#ifndef  WORD                                      // If WORD not yet defined
#define  WORD                                      // Set definition
typedef  unsigned int  word;                       // Typedef word type
#endif

//#define  DEBUG                                   // Un-comment for DEBUG
//#define  ROUTE                                   // Router-finding or not


/****************************************************************************/
/*                                                                          */
/***  Macros                                                              ***/
/*                                                                          */
/****************************************************************************/

#ifdef _MSC_VER                                    // If a Microsoft compiler
#define  cursorOn()  _settextcursor(0x0607)        // Turn cursor on
#define  cursorOff() _settextcursor(0x2000)        // Turn cursor off
#define gotoxy(col, row) \
  _settextposition((int) row, (int) col)           // gotoxy() macro
#else                                              // If a Borland compiler
#define  cursorOn()  _setcursortype(_NORMALCURSOR) // Turn cursor on
#define  cursorOff() _setcursortype(_NOCURSOR)     // Turn cursor off
#endif


/****************************************************************************/
/*                                                                          */
/***  Network data definitions                                            ***/
/*                                                                          */
/****************************************************************************/

#define NAMELEN            12                       // Length of name string
#define MSGLEN             70                       // Max message length
#define USERTOTAL          30                       // Total users

#define SIGNATURE      0x913F                       // Packet signature word

#define pPING          0x3001                       // Ping packet
#define pPINGRESPONSE  0x3002                       // Ping response
#define pBROADCAST     0x3003                       // Broadcast message
#define pMESSAGE       0x3004                       // Directed message
#define pFLURRY        0x3005                       // Flurry packet

struct LANTESTPKT                                   // LANTEST packet
  {
    word signature;                                 // Signature word
    word type;                                      // Packet type
    word ipxRecvMax;                                // Receive ECB statistic
    word ipxSendMax;                                // Send ECB statistic
    char name[NAMELEN + 1];                         // Name string
    char msg[MSGLEN + 1];                           // Message string
  };

struct USER                                         // Info on one user
  {
    byte inUse;                                     // struct in use or not
    word ipxRecvMax;                                // Receive ECB statistic
    word ipxSendMax;                                // Send ECB statistic
    struct IPXADDRFULL addr;                        // Address of user
    char name[NAMELEN + 1];                         // Name of user
  };


/****************************************************************************/
/*                                                                          */
/***  Network data structure                                              ***/
/*                                                                          */
/****************************************************************************

If the define DEBUG at the top of this file is TRUE, then LANTEST will use
the following structure as the LANLIB memory block.  This is useful for
viewing the contents of IPX structures during debugging.  If DEBUG is
FALSE, then a block of malloc()'ed memory will be used instead.             */

#ifdef DEBUG                                       // If DEBUG is defined
struct IPXDATA                                     // IPX data structure
  {
    #if    IPXRECVCNT                              // If receive count >= 1
    struct ECB         recvECB[IPXRECVCNT];        // Receive ECBs
    struct IPXPKTHDR   recvHdr[IPXRECVCNT];        // Receive packet headers
    #if    IPXDATASIZE                             // If IPXDATASIZE >= 1
    byte   recvBuf[IPXRECVCNT][IPXDATASIZE];       // Receive buffers
    #endif
    struct IPXEVENT    recvQueue[IPXRECVCNT];      // Receive event queue
    #endif
    #if    IPXSENDCNT                              // If send count >= 1
    struct ECB         sendECB[IPXSENDCNT];        // Send ECBs
    struct IPXPKTHDR   sendHdr[IPXSENDCNT];        // Send packet headers
    #if    IPXDATASIZE                             // If IPXDATASIZE >= 1
    byte   sendBuf[IPXSENDCNT][IPXDATASIZE];       // Send buffers
    #endif
    struct IPXEVENT    sendQueue[IPXSENDCNT];      // Send event queue
    #endif
  };
#endif                                             // End if DEBUG


/****************************************************************************/
/*                                                                          */
/***  Color and screen definitions                                        ***/
/*                                                                          */
/****************************************************************************/

#define  cBACKGRND      1                          // Background color
#define  cFOREGRND      7                          // Foreground color

#define  MAXCOLS      100                          // Max screen columns


/****************************************************************************/
/*                                                                          */
/***  Global data definitions                                             ***/
/*                                                                          */
/****************************************************************************/

extern byte endProgram;                            // End program flag
extern char emptyStr[1];                           // Empty string
extern char str[100];                              // Scratch string

extern char cmdStr[MAXCOLS];                       // Command string
extern byte inputFlag;                             // End of input flag

extern byte cols, rows;                            // Screen size
extern byte iCol, iRow;                            // Input window cursor pos
extern byte mCol, mRow;                            // Main window cursor pos
extern char strBlank[MAXCOLS + 1];                 // Blank line string


/****************************************************************************/
/*                                                                          */
/***  Function prototypes                                                 ***/
/*                                                                          */
/****************************************************************************/

// INPUT.C                                         // Input processing

void cmdHelp(void);                                // Displays help message
void cmdProcess(void);                             // Processes commands
void getKeys(void);                                // Collects keyboard input


// NETWORK.C                                       // High-level IPX funcs

void nameSet(void);                                // Sets user name
void nStart(void);                                 // Sets up network stuff
void nStop(void);                                  // Stops network stuff
void recvBroadcast(void);                          // Processes broadcasts
void recvMessage(void);                            // Processes messages
void recvPacket(void);                             // Processes incoming pkts
void recvPing(void);                               // Processes pings
void recvPingResponse(void);                       // Processes ping response
void routeDisplay(void);                           // Displays known networks
void routeFind(void);                              // Finds network segments
word routeWait(word netsFound);                    // Called while waiting
void sendBroadcast(void);                          // Sends broadcast
void sendErr(void);                                // Checks for send errors
void sendFlurry(void);                             // Sends "flurry" packets
void sendFlurryMode(void);                         // Sets flurry mode
void sendMessage(void);                            // Sends message
void sendPing(void);                               // Sends ping packet
void statDisplay(void);                            // Displays statistics
void userClear(void);                              // Clears user table
void userDisplay(void);                            // Displays known users
void userSave(void);                               // Saves info on user


// PROCESS.C                                       // Misc processing

void demoStart(void);                              // Starts up subsystems
void demoStop(void);                               // Stops subsystems
word err(word error);                              // Displays error messages


// VIDEO.C                                         // Video routines

void message(char *str);                           // Displays screen message
void messageBack(void);                            // Backs up message line
void vidCLS(void);                                 // Clears the screen
void vidScroll(void);                              // Scrolls main window
void vidStart(void);                               // Starts up video stuff
void vidStop(void);                                // Stops video stuff
