// INPUT.C -- Input routines for LANTEST
// Copyright (c) 1994 by Allen Brunson  version 1.00  06/30/94

#include <conio.h>     // kbhit()
#include <string.h>    // strcmp(), strcpy(), strlen(), strupr()
#ifdef _MSC_VER        // If a Microsoft compiler
#include <graph.h>     // settextcursor(), settextposition()
#endif
#include "lantest.h"   // LANTEST-specific defines


/****************************************************************************/
/*                                                                          */
/***  Command definitions                                                 ***/
/*                                                                          */
/****************************************************************************/

#ifdef  ROUTE                                      // If router-finding
#define CMDTOTAL    25                             // Cmd total, plus dupes
#else                                              // If not router-finding
#define CMDTOTAL    22                             // Cmd total, plus dupes
#endif

#define cBROADCAST   1                             // Broadcast message
#define cCLS         2                             // Clears the screen
#define cDISPLAY     3                             // Displays known users
#define cFLURRY      4                             // Flurry mode
#define cHELP        5                             // Help
#define cMESSAGE     6                             // Targeted message
#define cNAME        7                             // Set name
#define cNETWORKS    8                             // Display networks
#define cPING        9                             // Send ping packet
#define cROUTEFIND  10                             // Find routers
#define cSTAT       11                             // Statistics
#define cQUIT       12                             // Quit program

struct COMMAND                                     // Command structure
  {
    char *str;                                     // Command string
    word code;                                     // Command code
  };


/****************************************************************************/
/*                                                                          */
/***  Global data                                                         ***/
/*                                                                          */
/****************************************************************************/

char cmdStr[MAXCOLS];                              // Command string
byte inputFlag = FALSE;                            // End of input flag

struct COMMAND cmd[CMDTOTAL] =                     // Command strings
  {
    {"B",         cBROADCAST},                     // Broadcast
    {"BROADCAST", cBROADCAST},                     // Broadcast
    {"CLS",       cCLS},                           // Clear screen
    {"D",         cDISPLAY},                       // Display users
    {"DISPLAY",   cDISPLAY},                       // Display users
    {"F",         cFLURRY},                        // Flurry mode
    {"FLURRY",    cFLURRY},                        // Flurry mode
    {"H",         cHELP},                          // Help
    {"HELP",      cHELP},                          // Help
    {"M",         cMESSAGE},                       // Message
    {"MESSAGE",   cMESSAGE},                       // Message
    {"N",         cNAME},                          // Name
    {"NAME",      cNAME},                          // Name
    {"NET",       cNETWORKS},                      // Display networks
    {"NETWORK",   cNETWORKS},                      // Display networks
    {"NETWORKS",  cNETWORKS},                      // Display networks
    {"P",         cPING},                          // Ping packet
    {"PING",      cPING},                          // Ping packet

    #ifdef ROUTE                                   // If router-finding
    {"R",         cROUTEFIND},                     // Router finder
    {"ROUTE",     cROUTEFIND},                     // Router finder
    {"ROUTEFIND", cROUTEFIND},                     // Router finder
    #endif                                         // End if router-finding

    {"S",         cSTAT},                          // Statistics
    {"STAT",      cSTAT},                          // Statistics
    {"Q",         cQUIT},                          // Quit
    {"QUIT",      cQUIT},                          // Quit
  };


/****************************************************************************/
/*                                                                          */
/***  cmdHelp()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure displays a list of user commands.                            */

void cmdHelp(void)                                 // Begin cmdHelp()
  {
    message(emptyStr);
    message("Commands:");
    message("BROADCAST, B [message]          Broadcast message to all users");
    message("CLS                             Clear the screen");
    message("DISPLAY, D                      Show known users");
    message("FLURRY, F [ON | OFF | RESET]    Toggle flurry sends, reset count");
    message("HELP, H                         Print this message");
    message("MESSAGE, M [usernum] [message]  Send message to one user");
    message("NAME, N [name]                  Set your name");
    message("NETWORKS, NET [filename]        Display known networks");
    message("PING, P                         Update known users");
    #ifdef ROUTE                                   // If router-finding
    message("ROUTEFIND, ROUTE, R             Update known networks");
    #endif                                         // End if router-finding
    message("STAT, S [RESET]                 Display or reset ECB statistics");
    message("QUIT, Q                         End the program");
    message(emptyStr);
    message("The text of a received message is interpreted as a command.");
    message(emptyStr);
    message("Keys:");
    message("F1                              Same as HELP");
    message("F3                              Recall last command line");
    message("Esc                             Clear command line");
    message(emptyStr);
  }                                                // End cmdHelp()


/****************************************************************************/
/*                                                                          */
/***  cmdProcess()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure processes commands entered by the user.                      */

void cmdProcess(void)                              // Begin cmdProcess()
  {
    word i, j;                                     // Loop variables
    byte iFlag;                                    // Copy of input flag

    if (inputFlag == FALSE) return;                // Return if no input

    iFlag = inputFlag;                             // Save input flag
    inputFlag = FALSE;                             // Clear input flag

    if (strlen(cmdStr) == 0) return;               // Return if zero-length

    j = 0; while (cmdStr[j] == ' ') j++;           // Go past spaces

    for (i = 0; cmdStr[j] != 0 &&                  // Copy first word from
     cmdStr[j] != ' '; i++, j++)                   //  cmdStr to str
      str[i] = cmdStr[j];

    str[i] = 0;                                    // Terminate the string
    strupr(str);                                   // str to uppercase

    for (i = 0; i < CMDTOTAL; i++)                 // Loop for all commands
      if (!strcmp(str, cmd[i].str))                // If a match is found
        switch (cmd[i].code)                       // Decision on code
          {
            case cBROADCAST:                       // Broadcast
              if (iFlag == 2) return;              // Ignore remote requests
              sendBroadcast();                     // Call sendBroadcast()
              return;

            case cCLS:                             // CLS
              vidCLS();                            // Call vidCLS()
              return;

            case cDISPLAY:                         // Display
              userDisplay();                       // Display users
              return;

            case cFLURRY:                          // Flurry
              sendFlurryMode();                    // Set flurry mode
              return;

            case cHELP:                            // Help
              cmdHelp();                           // Display command help
              return;

            case cMESSAGE:                         // Message
              if (iFlag == 2) return;              // Ignore remote requests
              sendMessage();                       // Call sendMessage()
              return;

            case cNAME:                            // Name
              nameSet();                           // Set user name
              return;

            case cNETWORKS:                        // Display networks
              routeDisplay();                      // Call routeDisplay()
              return;

            case cPING:                            // Ping
              sendPing();                          // Send ping packet
              return;

            #ifdef ROUTE                           // If router-finding
            case cROUTEFIND:                       // Find routers
              routeFind();                         // Call router-finder
              return;
            #endif

            case cSTAT:                            // Statistics
              statDisplay();                       // Display statistics
              return;

            case cQUIT:                            // Quit
              endProgram = TRUE;                   // Set endProgram flag
              return;
          }

    if (iFlag == 1)                                // If not a remote command
      {
        message(emptyStr);                         // Print blank line
        message("Unrecognized command.  "          // Display this message
         "Press F1 for list.");                    //  if no match found
        message(emptyStr);                         // Print blank line
      }
  }                                                // End cmdProcess()


/****************************************************************************/
/*                                                                          */
/***  getKeys()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure processes one key of user input at a time.  When Enter is
pressed, it copies the command string to cmdStr.                            */

void getKeys(void)                                 // Begin getKeys()
  {
    static char inputStr[MAXCOLS];                 // Input string
    static char inputStrOld[MAXCOLS];              // Previous string
    static char inputLen;                          // Input length

    word key;                                      // Key value

    if (!kbhit()) return;                          // Return if no keys

    key = getch();                                 // Get the key
    if (!key) key = 0x7500 + getch();              // Get "special" keys

    if (key == 0x754D) key = (word) ' ';           // Right arrow to space

    switch(key)                                    // Decision on key
      {
        case 0x753B:                               // F1 key
          strcpy(cmdStr, "H");                     // Set "help" string
          inputFlag = TRUE;                        // Input is ready
          return;

        case 0x753D:                               // F3 key
          strcpy(inputStr, inputStrOld);           // Copy old inputStr
          inputLen = strlen(inputStr);             // Set new input length
          iCol = inputLen + 2;                     // Set new column
          cursorOff();                             // Turn off cursor
          gotoxy(2, iRow);                         // Go to line start
          cprintf(inputStr);                       // Print string
          gotoxy(iCol, iRow);                      // Update cursor pos
          cursorOn();                              // Turn on cursor
          return;

        case 0x000D:                               // Enter (fall thru to ESC)
          strcpy(cmdStr, inputStr);                // Copy string to cmdStr
          strcpy(inputStrOld, inputStr);           // Save for F3 use
          inputFlag = TRUE;                        // Input is ready

        case 0x001B:                               // Esc
          iCol = 2;                                // Go to left column
          cursorOff();                             // Turn off cursor
          gotoxy(iCol, iRow);                      // Cursor to left column
          cprintf(strBlank);                       // Print blank string
          gotoxy(iCol, iRow);                      // Cursor to left column
          cursorOn();                              // Turn on cursor
          inputStr[0] = 0;                         // Clear out inputStr
          inputLen = 0;                            // Clear input length
          return;

        case 0x0008: case 0x754B:                  // Backspace, left arrow
          if (iCol <= 2) return;                   // Return if at left side
          iCol--;                                  // Go back one column
          gotoxy(iCol, iRow);                      // Position cursor
          putch(' ');                              // Destroy old character
          gotoxy(iCol, iRow);                      // Position cursor
          inputLen--;                              // Subtract one key
          inputStr[inputLen] = 0;                  // Remove it from string
          return;

        default:                                   // Any other key
          if (key < 32 || key > 254) return;       // Throw away non-ASCIIs
          if (iCol >= cols - 1) return;            // Return if too far right
          putch(key); iCol++;                      // Put key on screen
          inputStr[inputLen] = (char) key;         // Put key in string
          inputLen++;                              // Increase input length
          inputStr[inputLen] = 0;                  // Terminate string
          return;
      }                                            // End switch()
  }                                                // End getKeys()
