#include <swlance.h>
/*****************************************************************************
* CopyRight (C) 1992,1993 by Todd Werelius.                                  *
*                                                                            *
* You may use these functions in any product as long as the copyright is     *
* included.  This function may not be sold as a product itself or as part of *
* a source code library.  The author takes no responsibilty for its use or   *
* distribtution.  This is a very touchy systems level routine, bad things    *
* can happen so BEWARE!                                                      *
*                                                                            *
*****************************************************************************/
int FAR PASCAL LibMain(HANDLE h_inst, WORD w_dataSeg, WORD w_heapSize, LPSTR ac_cmdLine)
{
    if (w_heapSize > 0) UnlockData(0);
    return TRUE;
}

int FAR PASCAL WEP(int i_param)
{
    return 1;
}

/*****************************************************************************
* This function has the capability to hook into any function in the Windows  *
* DLL's.  You can therefore produce a PRE & POST process for any function    *
* that Windows supports.  The Function must be supported by a PID # that     *
* is an english mnomic that points into an array of structures holding       *
* patch information. (SEE LANCE.H)                                           *
*****************************************************************************/
BOOL FAR PASCAL Intercept(WORD w_patchID, FARPROC p_newFunc)
{
    /************************************************************************
    * First we get the offset & selector of the interceptor function        *
    ************************************************************************/
    WORD w_newFuncOff = LOWORD(p_newFunc);
    WORD w_newFuncSel = HIWORD(p_newFunc);

    if (as_PI[w_patchID].b_patched != FALSE) return SW_ALREADYPATCHED;
    if (w_patchID > PID_LASTPID)             return SW_INVALIDPID;

    /************************************************************************
    * Now we load an OPCode instruction that tells the intercepted function *
    * to jump to our new function.                                          *
    ************************************************************************/
    as_PI[w_patchID].ab_jmpCode[0] = 0xEA;// FAR JMP OPCode
    as_PI[w_patchID].ab_jmpCode[1] = LOBYTE(w_newFuncOff);
    as_PI[w_patchID].ab_jmpCode[2] = HIBYTE(w_newFuncOff);
    as_PI[w_patchID].ab_jmpCode[3] = LOBYTE(w_newFuncSel);
    as_PI[w_patchID].ab_jmpCode[4] = HIBYTE(w_newFuncSel);

    /************************************************************************
    * Now we get the selector address of the function we want to intercept. *
    * Then we make a new selector entry that has read write capabilitys.    *
    * We must also lock the functions code so that it cannot be discarded   *
    * from memory (invalidating our intercept)                              *
    ************************************************************************/
    as_PI[w_patchID].w_readSel = HIWORD(as_PI[w_patchID].p_oldFunc);
    GlobalPageLock(as_PI[w_patchID].w_readSel);
    as_PI[w_patchID].w_writeSel = AllocSelector(as_PI[w_patchID].w_readSel);
    PrestoChangoSelector(as_PI[w_patchID].w_readSel,as_PI[w_patchID].w_writeSel);
    as_PI[w_patchID].p_oldFuncOPCodes = (LPSTR) MAKELONG(LOWORD(as_PI[w_patchID].p_oldFunc),as_PI[w_patchID].w_writeSel);

    /************************************************************************
    * Copy the original OP codes for safe keeping.  Then Copy the new JMP   *
    * instruction that will route the call to our function into its place   *
    ************************************************************************/
    _fmemcpy(as_PI[w_patchID].ab_oldCode,as_PI[w_patchID].p_oldFuncOPCodes,CPBYTES);
    _fmemcpy(as_PI[w_patchID].p_oldFuncOPCodes,as_PI[w_patchID].ab_jmpCode,CPBYTES);
    as_PI[w_patchID].b_patched = TRUE;
    return TRUE;
}

/****************************************************************************
* This function will undo an intercept function if the function was         *
* marked as hooked and the PID # is valid.                                  *
****************************************************************************/
BOOL FAR PASCAL Release(WORD w_patchID)
{
    /************************************************************
    * Make sure this PID is valid and that the function was     *
    * patched.                                                  *
    ************************************************************/
    if (as_PI[w_patchID].b_patched != TRUE) return SW_NOTPATCHED;
    if (w_patchID > PID_LASTPID)            return SW_INVALIDPID;

    /************************************************************
    * Put back the original code and unLock the code selector,  *
    * finally release the allocated selector, and mark the PID  *
    * as unpatched.                                             *
    ************************************************************/
    _fmemcpy(as_PI[w_patchID].p_oldFuncOPCodes,&(as_PI[w_patchID].ab_oldCode),CPBYTES);
    GlobalPageUnlock(as_PI[w_patchID].w_readSel);
    FreeSelector    (as_PI[w_patchID].w_writeSel);
    as_PI[w_patchID].b_patched = FALSE;
}

/****************************************************************************
* This function will return a PID pointer that is related to the PID # that *
* a function is supported by the new function in the link.                  *
****************************************************************************/
s_PATCHINFO FAR * FAR PASCAL GetPID(WORD w_patchID)
{
    if (w_patchID > PID_LASTPID) return NULL;
    return &(as_PI[w_patchID]);
}

/****************************************************************************
* This is an example of the DLL intercept function in use.  The function    *
* uses a hard coded index into an array of PID (program intercept data)     *
* structures.  One structure for each hooked function must exist.           *
* The second requirement is that the intercept function be a duplicate      *
* calling image so that the parameters match.  Just get the proto from      *
* <windows.h> and change the name to i_FunctionName.                        *
*                                                                           *
* The function needs to be set with a call to intercept (See Above)         *
* After that, this function will recieve control whenever the function is   *
* called by any windows program (including windows itself)                  *
*                                                                           *
* There are a few bewares.  Hooking SendMessage can cause problems because  *
* that function could spawn more send messages (A Recursive Loop could be   *
* spawned OOPS!!! can you say "Stack Overflow")                             *
****************************************************************************/
BOOL FAR PASCAL i_RegisterClass(LPWNDCLASS lpWndClass)
{
    BOOL             t_result;
    s_PATCHINFO FAR *ps_PI    = GetPID(PID_REGISTERCLASS);

    /***********************************************************
    * This undoes the patch (momentarily) so that the real     *
    * function can be called.                                  *
    ***********************************************************/
    _fmemcpy(ps_PI->p_oldFuncOPCodes,ps_PI->ab_oldCode,CPBYTES);


    // PreProcess Here
    t_result = RegisterClass(lpWndClass);
    // PostProcess Here

    /***********************************************************
    * This resets the patch (until next call or release        *
    ***********************************************************/
    _fmemcpy(ps_PI->p_oldFuncOPCodes,ps_PI->ab_jmpCode,CPBYTES);

    return t_result;
}





