//	=========================================================================
//	Project...:	kscxms.lib
//	File Name.:	xmsobjm.h
// Date......:	October 17, 1994
//	Version...:	6.2
//	COPYRIGHT (c) 1994 by Kenneth S. Cascio.  All Rights Reserved
//	=========================================================================

#ifndef	__XMSOBJM_H
#define	__XMSOBJM_H

#define	NOXMSOBJ

#include <xmsmain.h>

template<class T>
void XMSOBJM<T>::verify(int level)
{
	if (!access) error(ERR_NOACCESS);

	switch (level) {
		case 0:
			if (tLevel) error(ERR_TLEVEL);
			if (!tSubs) error(ERR_NOTARRAY);
			if (!(access->status)) error(ERR_STATUS);

			break;

		case 1:
			if (!(access->status)) error(ERR_STATUS);
			if ((access->frameSize) == 0) error(ERR_FRAMESIZE);

			break;

		case 2:
			if (!(access->status)) error(ERR_STATUS);
			if ((access->frameSize) == 0) error(ERR_FRAMESIZE);
			if (!tLevel && tVars) error(ERR_NOITEM);

			break;
	}
}

template<class T>
XMSOBJM<T>::XMSOBJM()
{
	tVars = 0;
	tSubs = NULL;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	object = new T[(access->frameSize)];
	if (!object) error(ERR_OBJECT);

	(access->frame) = (void huge *)object;
}

template<class T>
XMSOBJM<T>::XMSOBJM(unsigned long m)
{
	tVars = 1;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = 1;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = m;
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJM<T>::XMSOBJM(unsigned long m, unsigned long n)
{
	tVars = 2;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = n;
		tSubs[1][0] = n - 1;
		tSubs[1][1] = 1;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJM<T>::XMSOBJM(unsigned long m, unsigned long n, unsigned long o)
{
	tVars = 3;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = o;
		tSubs[2][0] = o - 1;
		tSubs[2][1] = 1;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJM<T>::XMSOBJM(unsigned long m, unsigned long n, unsigned long o,
	unsigned long p)
{
	tVars = 4;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o * p);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = (o * p);
		tSubs[2][0] = o - 1;
		tSubs[2][1] = p;
		tSubs[3][0] = p - 1;
		tSubs[3][1] = 1;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o * p);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJM<T>::XMSOBJM(unsigned long m, unsigned long n, unsigned long o,
	unsigned long p, unsigned long q)
{
	tVars = 5;
	tSubs = new unsigned long[tVars][2];
	if (!tSubs) error(ERR_TSUBS);
		tSubs[0][0] = m - 1;
		tSubs[0][1] = (n * o * p * q);
		tSubs[1][0] = n - 1;
		tSubs[1][1] = (o * p * q);
		tSubs[2][0] = o - 1;
		tSubs[2][1] = (p * q);
		tSubs[3][0] = p - 1;
		tSubs[3][1] = q;
		tSubs[4][0] = q - 1;
		tSubs[4][1] = 1;
	tOwner = this;
	tLevel = 0;
	tItem = 0;

	access = new XMSACCESS();
	if (!access) error(ERR_NEWACCESS);

	(access->frameSize) = FrameSize;
	(access->elements) = (m * n * o * p * q);
	(access->checkFrame)(sizeof(T));

	object = new T[(access->frameSize)];
	if (!object) (access->frameSize) = 0;
	(access->frame) = (void huge *)object;

	if (!(access->allocate)(sizeof(T))) error(ERR_ALLOCATE);
}

template<class T>
XMSOBJM<T>::XMSOBJM(XMSOBJM &pass)
{
	object = new T[1];
	if (!object) error(ERR_OBJECT);

	tVars = pass.tVars;
	tSubs = NULL;
	tOwner = pass.tOwner;
	tLevel = pass.tLevel + 1;
	tItem = pass.tItem;

	access = pass.access;

	if (pass.tLevel) {
		object[0] = pass.object[0];
	} else {
		object[0] = pass.object[(access->scope)(pass.tItem)];
	}
}

template<class T>
XMSOBJM<T>::~XMSOBJM()
{
	if (!tLevel) {
		if (access) {
			if (access->status) (access->release)();
			delete access;
		}

		if (tSubs) delete[] tSubs;
	}

	if (object) delete[] object;
}

template<class T>
T XMSOBJM<T>::operator*(void)
{
	verify(2);

	return object[0];
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator[](unsigned long m)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);

	if (m < (access->elements)) {
		tItem = m;
	} else {
		error(ERR_SUBRANGE);
	}

	return *this;
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator()(unsigned long m)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);
	if (tVars != 1) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);

	tItem = m;

	return *this;
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator()(unsigned long m, unsigned long n)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);
	if (tVars != 2) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]);

	return *this;
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);
	if (tVars != 3) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]);

	return *this;
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o, unsigned long p)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);
	if (tVars != 4) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);
	if (p > tSubs[3][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]) +
		(p * tSubs[3][1]);

	return *this;
}

template<class T>
XMSOBJM<T> XMSOBJM<T>::operator()(unsigned long m, unsigned long n,
	unsigned long o, unsigned long p, unsigned long q)
{
	verify(1);

	if (tLevel) error(ERR_TLEVEL);
	if (tVars != 5) error(ERR_TVARS);
	if (m > tSubs[0][0]) error(ERR_SUBRANGE);
	if (n > tSubs[1][0]) error(ERR_SUBRANGE);
	if (o > tSubs[2][0]) error(ERR_SUBRANGE);
	if (p > tSubs[3][0]) error(ERR_SUBRANGE);
	if (q > tSubs[4][0]) error(ERR_SUBRANGE);

	tItem = (m * tSubs[0][1]) + (n * tSubs[1][1]) + (o * tSubs[2][1]) +
		(p * tSubs[3][1]) + (q * tSubs[4][1]);

	return *this;
}

template<class T>
T XMSOBJM<T>::operator=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] = t;
	}

	object[0] = t;

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] =
			pass.object[0];
	}

	object[0] = pass.object[0];

	return object[0];
}

template<class T>
char XMSOBJM<T>::operator!(void)
{
	verify(2);

	return !(object[0]);
}

template<class T>
char XMSOBJM<T>::operator==(T t)
{
	verify(2);

	return (object[0] == t);
}

template<class T>
char XMSOBJM<T>::operator||(T t)
{
	verify(2);

	return (object[0] || t);
}

template<class T>
char XMSOBJM<T>::operator&&(T t)
{
	verify(2);

	return (object[0] && t);
}

template<class T>
char XMSOBJM<T>::operator!=(T t)
{
	verify(2);

	return (object[0] != t);
}

template<class T>
char XMSOBJM<T>::operator<(T t)
{
	verify(2);

	return (object[0] < t);
}

template<class T>
char XMSOBJM<T>::operator>(T t)
{
	verify(2);

	return (object[0] > t);
}

template<class T>
char XMSOBJM<T>::operator<=(T t)
{
	verify(2);

	return (object[0] <= t);
}

template<class T>
char XMSOBJM<T>::operator>=(T t)
{
	verify(2);

	return (object[0] >= t);
}

template<class T>
char XMSOBJM<T>::operator==(XMSOBJM &pass)
{
	verify(2);

	return (object[0] == pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator||(XMSOBJM &pass)
{
	verify(2);

	return (object[0] || pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator&&(XMSOBJM &pass)
{
	verify(2);

	return (object[0] && pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator!=(XMSOBJM &pass)
{
	verify(2);

	return (object[0] != pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator<(XMSOBJM &pass)
{
	verify(2);

	return (object[0] < pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator>(XMSOBJM &pass)
{
	verify(2);

	return (object[0] > pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator<=(XMSOBJM &pass)
{
	verify(2);

	return (object[0] <= pass.object[0]);
}

template<class T>
char XMSOBJM<T>::operator>=(XMSOBJM &pass)
{
	verify(2);

	return (object[0] >= pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator+(T t)
{
	verify(2);

	return (object[0] + t);
}

template<class T>
T XMSOBJM<T>::operator-(T t)
{
	verify(2);

	return (object[0] - t);
}

template<class T>
T XMSOBJM<T>::operator*(T t)
{
	verify(2);

	return (object[0] * t);
}

template<class T>
T XMSOBJM<T>::operator/(T t)
{
	verify(2);

	return (object[0] / t);
}

template<class T>
T XMSOBJM<T>::operator%(T t)
{
	verify(2);

	return (T)((long)object[0] % (long)t);
}

template<class T>
T XMSOBJM<T>::operator+(XMSOBJM &pass)
{
	verify(2);

	return (object[0] + pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator-(XMSOBJM &pass)
{
	verify(2);

	return (object[0] - pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator*(XMSOBJM &pass)
{
	verify(2);

	return (object[0] * pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator/(XMSOBJM &pass)
{
	verify(2);

	return (object[0] / pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator%(XMSOBJM &pass)
{
	verify(2);

	return (T)((long)object[0] % (long)pass.object[0]);
}

template<class T>
T XMSOBJM<T>::operator+=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] += t;
	}

	object[0] += t;

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator-=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] -= t;
	}

	object[0] -= t;

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator*=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] *= t;
	}

	object[0] *= t;

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator/=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] /= t;
	}

	object[0] /= t;

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator%=(T t)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] =
			(T)((long)(tOwner->object[(access->scope)(tItem)]) %
			(long)t);
	}

	object[0] = (T)((long)object[0] % (long)t);

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator+=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] += pass.object[0];
	}

	object[0] += pass.object[0];

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator-=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] -= pass.object[0];
	}

	object[0] -= pass.object[0];

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator*=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] *= pass.object[0];
	}

	object[0] *= pass.object[0];

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator/=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] /= pass.object[0];
	}

	object[0] /= pass.object[0];

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator%=(XMSOBJM &pass)
{
	verify(2);

	if (tLevel) {
		tOwner->object[(access->scope)(tItem, Alter)] =
			(T)((long)(tOwner->object[(access->scope)(tItem)]) %
			(long)pass.object[0]);
	}

	object[0] = (T)((long)object[0] % (long)pass.object[0]);

	return object[0];
}

template<class T>
T XMSOBJM<T>::operator++(void)
{
	verify(2);

	if (tLevel) {
		++(tOwner->object[(access->scope)(tItem, Alter)]);
	}

	return ++(object[0]);
}

template<class T>
T XMSOBJM<T>::operator--(void)
{
	verify(2);

	if (tLevel) {
		--(tOwner->object[(access->scope)(tItem, Alter)]);
	}

	return --(object[0]);
}

template<class T>
T XMSOBJM<T>::operator++(int)
{
	verify(2);

	if (tLevel) {
		(tOwner->object[(access->scope)(tItem, Alter)])++;
	}

	return (object[0])++;
}

template<class T>
T XMSOBJM<T>::operator--(int)
{
	verify(2);

	if (tLevel) {
		(tOwner->object[(access->scope)(tItem, Alter)])--;
	}

	return (object[0])--;
}

template<class T>
ostream &operator<<(ostream &out_data, XMSOBJM<T> &pass)
{
	pass.verify(2);

	out_data << pass.object[0];

	return out_data;
}

template<class T>
istream &operator>>(istream &in_data, XMSOBJM<T> &pass)
{
	pass.verify(2);

	in_data >> pass.object[0];

	return in_data;
}

template<class T>
char XMSOBJM<T>::success(void)
{
	return ((access->status) && (access->frameSize));
}

template<class T>
int XMSOBJM<T>::loadMethod(ORIENTATION method)
{
	verify(0);

	if (method != Check) (access->orientation) = method;

	return (access->orientation);
}

template<class T>
int XMSOBJM<T>::frameSize(int newSize)
{
	verify(0);

	int oldFrameSize = (access->frameSize);

	if (newSize < 0) return (access->frameSize);
	if (newSize == (access->frameSize)) return (access->frameSize);
	if (newSize > (access->elements)) return (access->frameSize);

	if (object) {
		(access->saveFrame)();
		delete[] object;
	}

	object = NULL;
	(access->frame) = NULL;
	(access->frameSize) = newSize;

	if (newSize > 0) {
		(access->checkFrame)(sizeof(T));
		object = new T[(access->frameSize)];
		if (!object) {
			(access->frameSize) = oldFrameSize;
			object = new T[oldFrameSize];
			if (!object) (access->frameSize) = 0;
		}
		(access->frame) = (void huge *)object;
		(access->scope)(0);
	}

	return (access->frameSize);
}

template<class T>
char XMSOBJM<T>::copy(int direction, void huge *memPtr,
	unsigned long bytes, unsigned long offset)
{
	verify(0);

	if ((access->copy)(direction, memPtr, bytes, offset)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

template<class T>
void XMSOBJM<T>::kill(void)
{
	if (!access) error(ERR_NOACCESS);
	if (tLevel) error(ERR_TLEVEL);

	if (access->status) (access->release)();
	delete access;
	access = NULL;

	if (tSubs) {
		delete[] tSubs;
		tSubs = NULL;
	}

	if (object) {
		delete[] object;
		object = NULL;
		(access->frame) = NULL;
	}
}

#endif	//	__XMSOBJM_H

#undef	NOXMSOBJ
