#include <dir.h>
#include <stdlib.h>
#define  RO1          0x01                    //read-only file attribute
#define  DIR          0x10                    //directory attribute
#define  ARC          0x20                    //archive attribute
#define  RO2          0x21                    //archive read-only attribute
#define  ALL          0x67                    //hex 24+22+21+0 attributes
struct   ffblk        ff;                     //findfirst structure
int      done;                                //findfirst done indicator
int      retcode=1;                           //destroy function return code
int      destroyit(void);                     //destroy function prototype
char     origin[MAXPATH];                     //original starting directory
char     curdir[MAXPATH];                     //current directory
char     deldir[MAXPATH];                     //delete directory
char     drive[MAXDRIVE];                     //drive for fnsplit
char     dir[MAXDIR];                         //directory for fnsplit
char     file[MAXFILE];                       //file for fnsplit


int main(int argc, char *argv[])
{
  printf("\nKILLDIR-Kill Directory, (C) Copyright 1991, Gary D. Shank.\n");
  if (argc < 2) {
     printf("ERROR:  NO DIRECTORY SPECIFIED!\n");
     return(0);
  }
  strupr(argv[1]);
  done=findfirst(argv[1],&ff,DIR);
  if (done == -1 || ff.ff_attrib != DIR) {
     printf("ERROR:  %s DIRECTORY NOT FOUND!\n",argv[1]);
     return(0);
  }
  fnsplit(argv[1],drive,dir,file,0);          //split up current directory
  strupr(drive);                              //make sure it's upper case
  setdisk(drive[0]-65);                       //change drive
  chdir(argv[1]);                             //change to selected directory
  chdir("..");                                //go back one level
  getcwd(curdir,MAXPATH);                     //get parent directory
  strcpy(origin,curdir);                      //save off as origin directory
  strcpy(deldir,file);                        //set up delete directory
  chdir(deldir);                              //change to selected directory

  while (retcode==1) {
     retcode=destroyit();                     //destroy next directory
     if (retcode) chdir(deldir);              //change to new delete directory
     if (retcode==0) {                        //check for destroy completion
        chdir("..");                          //drop back one level
        rmdir(deldir);                        //kill empty directory
        getcwd(curdir,MAXPATH);               //get current directory
        fnsplit(curdir,drive,dir,file,0);     //split up current directory
        strcpy(deldir,file);                  //set delete directory
        if (strcmp(curdir,origin))            //not back to origin directory
           retcode=1;
     }
  }
  printf("Kill Directory Function Complete!\n");
  return(0);
}



/******************************************************************************
In the destroy function, the first findfirst loop is looking for directory
entries only.  If it finds another directory it then returns back so that it
can be called again with the next level deep directory.  This has the affect
of finding the lowest level directory first and working it's way back to the
highest level.  I could put the remove files loop within the same directory
search loop but I'm allowing for future modifications where it may ask the
user if it's ok to delete a particular directory or other modifications.
******************************************************************************/
int destroyit()
{
  done=findfirst("*.*",&ff,DIR);              //search all entries
  while (!done) {
     if (ff.ff_name[0] != '.') {              //skip over . & .. entries
        if (ff.ff_attrib==DIR) {              //check for directory
           strcpy(deldir,ff.ff_name);         //set new directory
           return(1);                         //return to be called again
        }
     }
     done=findnext(&ff);                      //search again
  }
  getcwd(curdir,MAXPATH);                     //get current directory
  printf("Killing %s directory.\n",curdir);

  done=findfirst("*.*",&ff,ALL);              //look for all file types
  while (!done) {
     if (ff.ff_attrib==RO1 || ff.ff_attrib==RO2)  //check for read-only file
        _chmod(ff.ff_name,1,ARC);             //change attrib for delete
     remove(ff.ff_name);                      //blow file away
     done=findnext(&ff);                      //search again
  }
  return(0);
}
