/*
	File        : kybd_led.c
	Description : Demonstration of how to control the Num Lock, Caps Lock
					  and Scroll Lock LED's on an IBM PC compatible keyboard.
	Date        : 28 December 1993
	Author      : David Cecil
	Compiler    : Borland C/C++ 3.1
	Target O/S  : MS-DOS 2.1+

	Feel free to use this code in any application, commercial or private.

	For other handy source code routines in C and assembly, call the
	Programmer's Playground BBS, sponsored by DC Micro Development
	at (606) 268-1251.
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>


#define ON           1
#define OFF          0
#define KYBD_STATUS  0x0417	/* keyboard shift status byte */



void LEDCapsLock( char bState )
{
	char byte ;

	if ( bState )
	{
		/* set bit 6 to turn on Caps Lock LED */
		byte = peekb( 0x0000, KYBD_STATUS ) | 0x40 ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ;
	}
	else
	{
		/* clear bit 6 to turn off it off */
		byte = peekb( 0x0000, KYBD_STATUS ) & 0x0bf ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ; /* turn off CAPS LOCK LED */
	}
}


void LEDNumLock( char bState )
{
	char byte ;

	if ( bState )
	{
		/* set bit 5 to turn on the Num Lock LED */
		byte = peekb( 0x0000, KYBD_STATUS ) | 0x20 ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ;
	}
	else
	{
		/* clear bit 5 to turn it off */
		byte = peekb( 0x0000, KYBD_STATUS ) & 0x0df ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ; /* turn off NUM LOCK LED */
	}
}


void LEDScrollLock( char bState )
{
	char byte ;

	if ( bState )
	{
		/* set bit 4 to turn on the Scroll Lock LED */
		byte = peekb( 0x0000, KYBD_STATUS ) | 0x10 ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ;
	}
	else
	{
		/* clear bit 4 to turn it off */
		byte = peekb( 0x0000, KYBD_STATUS ) & 0x0ef ;
		pokeb( 0x0000, KYBD_STATUS, byte ) ; /* turn off SCROLL LOCK LED */
	}
}


void main( void )
{
	LEDNumLock( OFF ) ;
	LEDCapsLock( OFF ) ;
	LEDScrollLock( OFF ) ;

	printf( "Press any key to turn Num Lock ON..." ) ;
	getch() ;     printf( "\n" ) ;
	LEDNumLock( ON ) ;

	printf( "Press any key to turn Caps Lock ON..." ) ;
	getch() ;     printf( "\n" ) ;
	LEDCapsLock( ON ) ;

	printf( "Press any key to turn Scroll Lock ON..." ) ;
	getch() ;     printf( "\n" ) ;
	LEDScrollLock( ON ) ;
}