/*
	WINDOWS.HPP - (C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#if !defined (__WINDOWS_HPP)
	#define __WINDOWS_HPP 1

	#include "jfklib.hpp"
	#include "msgloop.hpp"

	#define JFK_WINDOW 12121
	#define self 	   *this

	class WINDOW {

	  protected:
		static WORD		wCount;
		static MSGLOOP	msg;
		static FARPROC2 lpFnOOPWndProc;

		FARPROC2 lpDefWndProc;

		// Kernel Methods

		virtual METHOD WMNull	   (					   ) DEFMETH
		virtual METHOD WMCreate	   (LPCREATESTRUCT lpCreate);
		virtual METHOD WMDestroy   (					   );
		virtual METHOD WMMove	   (POINT pt			   ) DEFMETH
		virtual METHOD WMSize	   (
						WORD wSizing,
						int  nWidth,
						int  nHeigth
					   ) DEFMETH
		virtual METHOD WMActivate  (
						WORD wActivate,
						BOOL bMin,
						HWND hLast
					   );

		virtual METHOD WMSetFocus       (HWND hLast			    ) DEFMETH
		virtual METHOD WMKillFocus      (HWND hNext			    ) DEFMETH
		virtual METHOD WMEnable	        (BOOL bEnableFlag	    ) DEFMETH
		virtual METHOD WMSetRedraw      (BOOL bRedrawFlag	    );
		virtual METHOD WMSetText        (LPSTR lpText		    );
		virtual METHOD WMGetText        (LPSTR lpText, WORD wMax);
		virtual METHOD WMGetTextLength	(						);
		virtual METHOD WMPaint			(						);
		virtual METHOD WMClose			(						);

		virtual METHOD WMQueryEndSession () { return TRUE; }
		virtual METHOD WMQueryOpen		 () { return TRUE; }

		virtual METHOD WMEraseBkgnd		 (HANDLE hDC			);
		virtual METHOD WMSysColorChange	 (						) DEFMETH
		virtual METHOD WMEndSession		 (BOOL bEnded			) DEFMETH
		virtual METHOD WMShowWindow		 (BOOL bShow, long lShow);
		virtual METHOD WMCtlColor		 (
						HDC hCtlDC,
						WORD wCtlStyle,
						HWND hCtl
					   );

		virtual METHOD WMWinIniChange	(LPSTR lpSectionName) DEFMETH
		virtual METHOD WMDevModeChange	(LPSTR lpDeviceName	) DEFMETH
		virtual METHOD WMActivateApp	(
						BOOL bActivate,
						HANDLE hTask
					   ) DEFMETH
		virtual METHOD WMFontChange		() DEFMETH
		virtual METHOD WMTimeChange		() DEFMETH
		virtual METHOD WMCancelMode		();
		virtual METHOD WMSetCursor		(
						HCURSOR hCursorOwner,
						WORD	wNCHitTest,
						WORD	wMouseMsg
					 );
		virtual METHOD WMMouseActivate	(
						HWND hTopWnd,
						WORD NCHitTest,
						WORD wMouseMsg
					 );

		virtual METHOD WMChildActivate () DEFMETH
		virtual METHOD WMQueueSync	   () DEFMETH

		virtual METHOD WMGetMinMaxInfo	(LPRECT lprt) DEFMETH
		virtual METHOD WMPaintIcon		(BOOL bDraw	);
		virtual METHOD WMIconEraseBkgnd	(HDC hDC	);

		virtual METHOD WMNextDlgCtl    (WORD wNext, BOOL bNext) DEFMETH
		virtual METHOD WMSpoolerStatus (WORD wJobs			  ) DEFMETH

		virtual METHOD WMDrawItem	 (LPDRAWITEMSTRUCT lpDrawItem );
		virtual METHOD WMMeasureItem (LPMEASUREITEMSTRUCT lpItem  ) DEFMETH
		virtual METHOD WMDeleteItem	 (LPDELETEITEMSTRUCT lpDelItem) DEFMETH
		virtual METHOD WMVKeyToItem	 (
						WORD wKey,
						WORD wCaretPos,
						HWND hListBox
					   ) { return -1l; }
		virtual METHOD WMCharToItem	 (
						WORD wKey,
						int  nCaretPos,
						HWND hListBox
					   ) { return -1l; }
		virtual METHOD WMSetFont	 (HFONT hFont, BOOL bSofort) DEFMETH
		virtual METHOD WMGetFont	 (						   ) DEFMETH

		// Non-Client Messages

		virtual METHOD WMNCCreate   (
						HWND hWnd,
						LPCREATESTRUCT lpCreate
					   );
		virtual METHOD WMNCDestroy	(			 );
		virtual METHOD WMNCCalcSize	(LPRECT lprt );
		virtual METHOD WMNCHitTest	(POINT pt	 );
		virtual METHOD WMNCPaint	(HRGN hRgn	 );
		virtual METHOD WMNCActivate	(BOOL bActive);
		virtual METHOD WMGetDlgCode	(			 ) DEFMETH

		virtual METHOD WMNCMouseMove     (WORD wNCHitTest, POINT pt);
		virtual METHOD WMNCLButtonDown	 (WORD wNCHitTest, POINT pt);
		virtual METHOD WMNCLButtonUp	 (WORD wNCHitTest, POINT pt);
		virtual METHOD WMNCLButtonDblClk (WORD wNCHitTest, POINT pt);
		virtual METHOD WMNCRButtonDown	 (WORD wNCHitTest, POINT pt) DEFMETH
		virtual METHOD WMNCRButtonUp	 (WORD wNCHitTest, POINT pt) DEFMETH
		virtual METHOD WMNCRButtonDblClk (WORD wNCHitTest, POINT pt) DEFMETH
		virtual METHOD WMNCMButtonDown	 (WORD wNCHitTest, POINT pt) DEFMETH
		virtual METHOD WMNCMButtonUp	 (WORD wNCHitTest, POINT pt) DEFMETH
		virtual METHOD WMNCMButtonDblClk (WORD wNCHitTest, POINT pt) DEFMETH

		// Keyboard - support

		virtual METHOD WMKeyDown		 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   );
		virtual METHOD WMKeyUp			 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   );
		virtual METHOD WMChar			 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   ) DEFMETH
		virtual METHOD WMDeadChar		 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   ) DEFMETH
		virtual METHOD WMSysKeyDown		 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   );
		virtual METHOD WMSysKeyUp		 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   );
		virtual METHOD WMSysChar		 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   );
		virtual METHOD WMSysDeadChar	 (
						WORD wKey,
						WORD wRepeat,
						WORD wExtended
					   ) DEFMETH

		friend long FAR PASCAL DefOOPWndProc (HWND, WORD, WORD, LONG);

		// These are the MessageGroups supported by DefOOPWndProc

		virtual METHOD WndKernelProc (WORD wMsg, WORD wParam, long lParam);
		virtual METHOD WndTransProc  (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndCompProc   (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndNCProc     (WORD wMsg, WORD wParam, long lParam);
		virtual METHOD WndKeyProc    (WORD wMsg, WORD wParam, long lParam);
		virtual METHOD WndDlgProc    (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndMouseProc  (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndMdiProc    (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndClipProc   (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndDDEProc    (WORD wMsg, WORD wParam, long lParam) DEFMETH
		virtual METHOD WndUserProc   (WORD wMsg, WORD wParam, long lParam) DEFMETH

		HWND 	 EXPORT GetWindowHandle () const { return hWnd;		 		}
		HWND	 EXPORT GetParent		() const { return ::GetParent (hWnd);	}
		WORD	 EXPORT GetCount		() const { return wCount;		 		}
		FARPROC2 EXPORT GetOOPWndProc   () const;

		HWND hWnd;

		EXPORT WINDOW (
					WORD		wStyle,
					HCURSOR		hCursor,
					HICON		hIcon,
					HBRUSH		hBackground,
					WORD		wClsExtra,
					WORD		wWndExtra,
					LPSTR		lpClass,
					FARPROC2	lpFnProc
				);

	  public:
		EXPORT ~WINDOW ();
		EXPORT  WINDOW (
					int			nCmdShow	= SW_NORMAL,
					int			x			= CW_USEDEFAULT,
					int			y			= CW_USEDEFAULT,
					int			cx			= CW_USEDEFAULT,
					int			cy			= CW_USEDEFAULT,
					long		lStyle		= WS_OVERLAPPEDWINDOW,
					LPSTR   	lpName		= "",
					HANDLE		hMenu		= NULL,
					HANDLE		hParent		= NULL,
					long		lExStyle	= NULL,
					WORD		wStyle		= CS_VREDRAW | CS_HREDRAW,
					HCURSOR		hCursor		= LoadCursor (NULL, IDC_ARROW),
					HICON		hIcon		= NULL,
					HBRUSH		hBackground = COLOR_WINDOW+1,
					WORD		wClsExtra	= 0,
					WORD		wWndExtra	= 0,
					LPSTR		lpParam		= NULL,
					LPSTR		lpClass		= MAKEINTRESOURCE (JFK_WINDOW),
					FARPROC2	lpFnProc	= DefWindowProc
				);

		friend void EXPORT SetWindowText (const WINDOW &wnd, LPSTR lpText);
		friend void EXPORT ShowWindow    (const WINDOW &wnd, int nShow   );
		friend BOOL EXPORT IsWindow      (const WINDOW &wnd		         );
		friend int  EXPORT MsgLoop       (const WINDOW &wnd		         );
		friend long EXPORT SendMessage   (
							const WINDOW &wnd,
							WORD 		  wMsg,
							WORD 		  wParam = NULL,
							LONG 		  lParam = NULL
						   );
		friend long EXPORT PostMessage   (
							const WINDOW &wnd,
							WORD 		  wMsg,
							WORD 		  wParam = NULL,
							LONG 		  lParam = NULL
							);
	};

	#endif