/*
	TOPLEVEL.CPP - Generic Handling of TopLevel-Windows
	(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "toplevel.hpp"
	#include "about.hpp"

	METHOD TOPLEVEL::WMClose ()
	{
		DestroyWindow (GetWindowHandle ());

		return 0l;
	}
	EXPORT TOPLEVEL::TOPLEVEL (
			int			nCmdShow,
			int			x,
			int			y,
			int			cx,
			int			cy,
			long		lStyle,
			LPSTR   	lpName,
			LPSTR		lpMenu,
			long		lExStyle,
			WORD		wStyle,
			HCURSOR		hCursor,
			HICON		hIcon,
			HBRUSH		hBackGrnd,
			WORD		wClsExtra,
			WORD		wWndExtra,
			LPSTR		lpParam,
			LPSTR		lpClass,
			FARPROC2	lpFnProc
		 ) :
		WINDOW (
			SW_HIDE,
			x,
			y,
			cx,
			cy,
			lStyle,
			"",
			NULL,
			NULL,
			lExStyle,
			wStyle,
			hCursor,
			hIcon,
			hBackGrnd,
			wClsExtra,
			wWndExtra,
			lpParam,
			lpClass,
			lpFnProc
		)
	{
		HMENU hMenu = NULL;

		bHelpActive = FALSE;

		if (lpMenu)
			hMenu = LoadMenu (GetInstance (), lpMenu);

		if (hMenu)
			SetMenu (GetWindowHandle (), hMenu);

		SetWindowText (self, lpName  );
		ShowWindow    (self, nCmdShow);
	}


	METHOD TOPLEVEL::WMCommand (WORD wID, WORD wMsg, HWND hCtl)
	{
		switch (wID) {

		  case ID_FILE_EXIT:
			return SendMessage (self, WM_CLOSE, 0, 0L);

		  case ID_HELP_ABOUT:
			ABOUT about (MAKEINTRESOURCE (ID_HELP_ABOUT), GetWindowHandle ());

			about.SetItemText (
				ID_APPNAME,
				MAKEINTRESOURCE (ID_APPNAME)
			);
			about.modal ();

			return 0l;

		  case HELP_HELPONHELP:
			if (WinHelp (GetWindowHandle (), "", HELP_HELPONHELP, 0l))
				bHelpActive = TRUE;

			return 0l;

		}
		return NULL;
	}

	METHOD TOPLEVEL::WMDestroy ()
	{
		if (bHelpActive)
			WinHelp (GetWindowHandle (), "", HELP_QUIT, 0l);

		return WINDOW::WMDestroy ();
	}

	METHOD TOPLEVEL::WMSysCommand (WORD wID, POINT pt)
	{
		return DefWindowProc (
				GetWindowHandle (),
				WM_SYSCOMMAND,
				wID,
				*(long*)&pt
			   );
	}

	METHOD TOPLEVEL::WndDlgProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_COMMAND:
			return WMCommand (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_SYSCOMMAND:
			return WMSysCommand (wParam, MAKEPOINT (lParam));

		  case WM_TIMER:
			return WMTimer (wParam, (FARPROC) lParam);

		  case WM_HSCROLL:
			return WMHScroll (wParam, HIWORD (lParam));

		  case WM_VSCROLL:
			return WMVScroll (wParam, HIWORD (lParam));

		  case WM_INITMENU:
			return WMInitMenu (wParam);

		  case WM_INITDIALOG:
			return WMInitDialog (lParam);

		  case WM_INITMENUPOPUP:
			return WMInitMenuPopUp	(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
					 );

		  case WM_MENUSELECT:
			return WMMenuSelect (wParam, LOWORD (lParam));

		  case WM_MENUCHAR:
			return WMMenuChar (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_ENTERIDLE:
			return WMEnterIdle (wParam, LOWORD (lParam));

		}

		return DefWindowProc (GetWindowHandle (), wMsg, wParam, lParam);
	}