/*
	MDIMETH.CPP -(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "mdi.hpp"

	METHOD MDI::WMCommand (WORD wID, WORD wMsg, HWND hCtl)
	{
		switch (wID) {

		  case ID_MDI_CASCADE:
			return SendMessage (GetMDIClient (), WM_MDICASCADE,     0, 0l);

		  case ID_MDI_TILE:
			return SendMessage (GetMDIClient (), WM_MDITILE,        0, 0l);

		  case ID_MDI_ARRANGE:
			return SendMessage (GetMDIClient (), WM_MDIICONARRANGE, 0, 0l);

		}

		TOPLEVEL::WMCommand (wID, wMsg, hCtl);

		return DefFrameProc (
				GetWindowHandle (),
				GetMDIClient (),
				WM_COMMAND,
				wID,
				MAKELONG (hCtl, wMsg)
		   );
	}

	METHOD MDI::WMMenuSelect (WORD wMenu, WORD wFlag)
	{
		return DefFrameProc (
					GetWindowHandle (),
					GetMDIClient (),
					WM_MENUSELECT,
					wMenu,
					MAKELONG (wFlag, NULL)
			   );
	}

	METHOD MDI::WMMenuChar (WORD wKey, HMENU hMenu, WORD wMenu)
	{
		return DefFrameProc (
				GetWindowHandle (),
				GetMDIClient (),
				WM_MENUCHAR,
				wKey,
				MAKELONG (wMenu, hMenu)
		   );
	}

	METHOD MDI::WMSetFocus (HWND hLast)
	{
		return DefFrameProc (
				GetWindowHandle (),
				GetMDIClient (),
				WM_SETFOCUS,
				hLast,
				0l
			   );
	}

	METHOD MDI::WMSize	  (
					WORD wSizing,
					int  nWidth,
					int  nHeigth
				 )
	{
		return DefFrameProc (
				GetWindowHandle (),
				GetMDIClient (),
				WM_SIZE,
				wSizing,
				MAKELONG (nWidth, nHeigth)
		   );
	}

	METHOD MDI::WMSysCommand (WORD wID, POINT pt)
	{
		return DefFrameProc (
				GetWindowHandle (),
				GetMDIClient (),
				WM_SYSCOMMAND,
				wID,
				*(long*)&pt
			   );
	}

	METHOD MDI::WMClose	()
	{
		if (SendAllChildren (WM_QUERYENDSESSION, 0, 0l, TRUE))
			SendMessage (self, WM_DESTROY);

		return 0l;
	}

	METHOD MDI::WMQueryEndSession ()
	{
		return SendAllChildren (WM_QUERYENDSESSION, 0, 0l, TRUE);
	}

	METHOD MDI::WMDestroy ()
	{
		SendAllChildren (WM_CLOSE);

		return TOPLEVEL::WMDestroy ();
	}
