



                                  jdFLIB v1.0

                                Beta Release A

                          User's Guide and Reference

             Copyright 1993 James C. Dunavant, All Rights Reserved


                               James C. Dunavant
                              717 NE 5th Terrace
                             Gainesville, FL 32601
                                (904) 376-5876


         ======================== DISCLAIMER =========================
         THE LIBRARY "jdFLIB.LIB" AND THE DEMONSTRATION PROGRAM
         "jdDEMO.EXE" ARE PROVIDED "AS IS." IT IS THE RESPONSIBILITY
         OF THE END USER TO DETERMINE THE SUITABILITY OF SAID LIBRARY
         AND PROGRAM FOR ANY USE. THE AUTHOR, DISTRIBUTOR, OR AGENT
         THEREOF, SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT,
         SPECIAL, INCIDENTAL, CONSEQUENTIAL, OR SIMILAR DAMAGES
         RESULTING FROM THE USE OF THE ABOVE NAMED FILES. SOLE
         RESPONSIBILITY FOR THE USE OF THE FILES LIES WITH THE USER.
         YOUR USE OF THE ABOVE NAMED FILES EXPLICITLY CONFIRMS YOUR
         UNDERSTANDING AND AGREEMENT WITH THIS DISCLAIMER.
         =============================================================

         ======================= LEGAL NOTICE ========================
         The library "jdFLIB" is provided for evaluation purposes
         only. You MUST register your use of the library with the
         author BEFORE you distribute your program by any means
         including but not limited to commercial, shareware, freeware
         or public domain. You must also register your use of the
         library for in-house use. If you fail to register your use of
         the library, you will be in violation of the author's
         copyright which constitutes theft of intellectual property.
         =============================================================

         See the file "order.frm" to register your use of the library
         and receive the library source code.


         Modification History:
         1) First release, version 1.0, beta A  Dec '93






                                    i







                               = CONTENTS =

         Disclaimer & Legal Notice ...............................  i
         Modification History ....................................  i
         CONTENTS ................................................ ii
         INTRODUCTION ............................................  1
         jdFLIB Reference ........................................  2
              GLOBALS ............................................  3
                   jdHardRetry ...................................  3
                   jdVersion .....................................  3
                   jdBullet ......................................  3
                   jdUpDnRt ......................................  3
                   jdUpRt ........................................  3
                   jdUpDn ........................................  3
                   jdSpc .........................................  3
                   jdDrives ......................................  3
                   INV_DRIVE .....................................  3
                   PHANTOM_B .....................................  3
                   ALL_ATTR ......................................  3
              STRUCTURES .........................................  4
                   jdDLIST .......................................  4
                   jdTLIST .......................................  4
                   jdLLIST .......................................  5
              FUNCTIONS ..........................................  6
                   jdBuildDriveList() ............................  6
                   jdBuildDirList() ..............................  8
                   jdBuildTreeList() .............................  9
                   jdFreeDirList() ............................... 10
                   jdFreeTreeList() .............................. 11
                   jdConnectTree() ............................... 11
                   jdBuildPath() ................................. 12
                   jdBuildAttrStr() .............................. 12
                   jdWriteTreeLog() .............................. 13
                   jdReadTreeLog() ............................... 14
                   jdDelDirNode() ................................ 14
                   jdAddDirNode() ................................ 15
                   jdDelTreeNode() ............................... 16
                   jdAddTreeNode() ............................... 16











                                    ii




         jdFLIB v1.0 - User's Guide and Reference               Page 1
         -------------------------------------------------------------





                                 INTRODUCTION

         Now that we've got all the legal stuff out of the way, let's
         have some fun.  jdFLIB is a library of relatively high-level
         routines for building MS-DOS directory and directory tree
         lists.  Routines are provided to build complete pathnames,
         connection strings (for displaying a directory tree),
         attribute strings, and more. I'm calling this release "beta
         A" since (as of this writing) no other programmer has yet
         worked with the library. It has been extensively tested on a
         variety of machines (including over a network) and appears to
         be quite solid. However, that does not mean that bugs are not
         present, just that I have not discovered any yet. Please
         report any bugs, suggestions, etc. to the author at the
         address given ABOVE. You do not have to be a registered user
         to issue bug reports.

         The library is display independent. That is, jdFLIB does not
         draw anything to the screen, but rather provides you with the
         information needed to display directories, trees, or paths
         using any video mode you require.

         jdFLIB was written and compiled using Borland C/C++ version
         3.1. It is not known to be compatible with any other compiler
         other than the Borland C/C++ compilers. The library calls the
         Microsoft C compatibility functions provided by the Borland
         libraries (e.g., "calls _dos_findfirst()" rather than
         findfirst()"), so it may successfully link with MSC produced
         object modules. However, since I do not have MSC, this has
         not been tested.

         The library is compiled with "C" linkage in the "large" memory
         model. If you need another memory model, register your use of
         the library to receive the source code, and you can recompile
         it using the memory model you need. No model specific
         constructions are used in the library source code.

         Users of compilers other than Borland will need the source
         code to modify (as needed) and recompile for use with their
         compiler.

         C++ programmers can encapsulate the jdFLIB functions in
         classes of their own design.

         jdFLIB builds on the directory and disk functions provided




         jdFLIB v1.0 - User's Guide and Reference               Page 2
         -------------------------------------------------------------



         in the libraries that came with your compiler.  If you have
         ever tried to draw a directory tree to the screen, you know
         how hard it can be to figure out how to connect the directory
         names together with lines and angles to show the directory
         hierarchy. jdFLIB does this grunt work for you.  It not only
         scans your drive and builds the directory tree list, but it
         also constructs the "connection" strings needed to draw the
         tree. See the jdFLIB Reference below for more detail.

         A demo program, "jdDEMO.EXE" is provided (with source code)
         that demonstrates calls to jdFLIB. By studying this code
         as well as the function reference below, you should be up and
         running with jdFLIB in no time at all. jdDEMO was written
         solely to test and demonstrate the library. By itself it does
         not do anything but let you look around your system. jdDEMO
         was thrown together very quickly, and likely does have bugs
         (I was writing a library, not an application).

         Note: jdDEMO uses the Insert and Delete keys to delete and
               insert directory and tree nodes in the list. These do
               not change anything on disk (it's just pretend), so go
               ahead and delete and insert all you want.



                               jdFLIB Reference
                               ================

         Note 1: To avoid conflict with user identifiers and other
         libraries, all functions and global variables in jdFLIB are
         prefixed with the letters "jd".


         Note 2: All functions in jdFLIB return a pointer or true (1)
         on success, and return NULL or false (0) on failure. jdFLIB
         does not maintain a list of error codes. Since it is built on
         top of the functions in the compiler's libaries, you should
         check the value of "errno" to determine the cause of failure.
         See <errno.h> for a list of the possible errors. In some
         cases, jdFLIB will set errno to an appropriate value if some
         condition occurs that is an error, and the standard library
         does not set it.

         Note 3: It is important to remember that jdFLIB considers
         drive A to be 0, drive B to be 1, and so on. When you call
         those functions that take a drive argument, you must follow
         this 0-based numbering scheme or you will not get the results
         you expect.



         jdFLIB v1.0 - User's Guide and Reference               Page 3
         -------------------------------------------------------------




                                  = GLOBALS =

         int jdHardRetry
         ---------------
         If you have a critical error handler installed in your
         program (and you should), it should set "jdHardRetry" to 1 if
         the user selects "Retry" and to 0 if the user selects "Abort."
         This variable is declared in the header "jdFLIB.H." The
         functions in jdFLIB that read or write to disk check this
         variable to see if they should retry the operation that
         failed. If jdHardRetry is true (!= 0), the operation will
         repeat. An example of a critical error handler can be seen in
         the file JDDEMO.C included with this package.

         If you do not have a critical error handler installed, do not
         worry. jdFLIB will set jdHardRetry to 0 and leave it there.
         In other words, just ignore jdHardRetry.


         int jdVersion
         -------------
         This variable holds the jdFLIB.LIB version number as an int
         with an implied decimal point after the first digit. For this
         release jdVersion == 10.


         char jdBullet[3]
         char jdUpDnRt[4]
         char jdUpRt[4]
         char jdUpDn[4]
         char jdSpc[4]
         --------------
         See function jdConnectTree() below.

         jdLLIST jdDrives[26]
         --------------------
         See struct jdLLIST below and function jdBuildDriveList().

         #define INV_DRIVE -1   /* Could not access drive */
         #define PHANTOM_B -2   /* Physical B drive not present */
         --------------------
         See function jdBuildDriveList() below.


         #define ALL_ATTR
         ----------------
         See function jdBuildDirList() below.




         jdFLIB v1.0 - User's Guide and Reference               Page 4
         -------------------------------------------------------------






                                = STRUCTURES =

         typedef struct Dlist {
            struct Dlist *Next;
            struct Dlist *Prev;
            char Name[9];
            char Ext[5];
            char Time[9];
            char Date[9];
            int Attrib;
            long Size;
            unsigned Flags;
            } jdDLIST;
              -------

         When you call jdBuildDirList() a pointer to the first in a
         linked list of jdDLIST structures is returned. You use this
         list to display or otherwise manipulate directory nodes. The
         members are defined as follows:

         Next, Prev - These are node links.
         Name[9]    - This array contains the filename string.
         Ext[5]     - Contains the file extension (including leading
                      dot).
         Time[9]    - The time string formatted as 00:00 xm. For
                      example: 01:30 pm
         Date[9]    - The date string formatted as MM-DD-YY.
         Attrib     - Bitwise file attributes. See jdBuildAttrStr().
         Size       - Size of the file in bytes.
         Flags      - This member is provided for your use. You've got
                      16 bits to set or reset as you see fit. jdFLIB
                      does not use this member.


         typedef struct Tlist {
            struct Tlist *Next;
            struct Tlist *Prev;
            struct Tlist *Parent;
            struct Tlist *ASib;
            int Level;
            char Name[13];
            unsigned Flags;
            } jdTLIST;
              -------



         jdFLIB v1.0 - User's Guide and Reference               Page 5
         -------------------------------------------------------------




         When you call jdBuildTreeList() a pointer to the first in a
         linked list of jdTLIST structures is returned. Normally you
         will only be interested in the "Name" member. jdFLIB contains
         functions that manipulate this structure for you. The members
         are defined as:

         Next, Prev - Node links.
         Parent     - Pointer to parent directory of this node.
         ASib       - Next adjacent sibling directory.
         Level      - Recursion level from root directory (0 == root).
         Name[13];  - Directory name (including extension, if any).
         Flags      - This member is provided for your use. You've got
                      16 bits to set or reset as you see fit. jdFLIB
                      does not use this member.


         typedef struct Llist {
            struct Llist *Next;
            struct Llist *Prev;
            struct Tlist *Tree;
            unsigned Remote;
            unsigned Cdrom;
            int Drive;
            void *User;
            } jdLLIST;

         When jdBuildDriveList() is called, it returns a pointer to
         the first in a linked list of jdLLIST structures. Note that
         this list is also held in the static array jdDrives[]. This
         allows you to parse the list as either a linked list or as an
         array, depending on your needs. The array is static and
         global. The members are defined as:

         Next, Prev - Node links.
         Tree       - Pointer to first node in jdTLIST list (the
                      directory tree for this drive). Note that jdFLIB
                      does NOT set this pointer. You must set it once
                      the tree list has been created.
         Drive      - Ordinal drive number. A = 0, B = 1, C = 2, etc.
                      If jdBuildDriveList could not access the drive,
                      the value will be set to INV_DRIVE. Only drive C
                      and above will be looked at. Drive B will be set
                      to PHANTOM_B if a physical B: is not detected.
         Remote     - Bitwise drive status. See DOS programmers manual
                      for details on all the bits. The bits that




         jdFLIB v1.0 - User's Guide and Reference               Page 6
         -------------------------------------------------------------



                      interest us here (defined in jdFLIB.H) are:

                      IS_UNKNOWN    - jdFLIB was unable to obtain
                                      information about the drive.
                                      No bits set.
                      IS_REMOTE     - The drive is a network drive
                                      not local to the machine your
                                      program is running on.
                      IS_SHARED     - The drive is local to the
                                      running machine, but is shared
                                      on the network.
                      IS_SUBSTITUTE - The drive is a substituted drive
                                      as set by the DOS "SUBST"
                                      command.

         Cdrom      - This member will be set to true is the drive is
                      a CD Rom drive.
         User       - Pointer to user data. You can point this to
                      anything you want. Typically you may want to
                      point to a struct of your own design to maintain
                      information about the drive indicated by
                      "Drive." Be sure to cast this pointer to your
                      data type when using.

         Note: If you parse this list as an array, you still need to
         look at the "Next" pointer. When Next becomes NULL, all
         succeeding elements in the array do not contain valid
         information.


                                 = FUNCTIONS =

         =============================================================
         jdBuildDriveList                                     jdFLIB.H
         =============================================================

          PROTOTYPE: jdLLIST *jdBuildDriveList(void)

         PARAMETERS: void.

             RETURN: Pointer to first in linked list of type jdLLIST.
                     Returns NULL on error.

         DISCUSSION: This function initializes the static global array
                     jdDrives[]. This array may be parsed as an
                     array or a linked list. The ordinal position in
                     the array is the logical drive number (i.e., A =




         jdFLIB v1.0 - User's Guide and Reference               Page 7
         -------------------------------------------------------------



                     0, B = 1, C = 2, D = 3, etc.).  Since the user
                     may have their LASTDRIVE variable set to Z or
                     some value greater than what they actually have,
                     the function (starting with drive C) attempts to
                     log on to each drive reported by DOS. If the
                     logon is successful, the Drive member will be set
                     to the ordinal value of the drive. If the logon
                     fails, Drive will be set to INV_DRIVE (-1).

                     This function also checks for the presence of a
                     physical drive B.  If B: is not found, Drive will
                     be set to PHANTOM_B (-2).  It is up to you to
                     decide what to do if the user attempts to access
                     a phantom drive B.

                     The Next member of the last logical drive will be
                     set to NULL indicating the end of the list.

         EXAMPLE:

         #include <stdio.h>
         #include <stdlib.h>
         #include "jdFLIB.H"

         void main()
         {
         static char *valid[] = {"Present"," a Phantom B:","Not present"};
         jdLLIST *first, *next;
         int drive, type;

         first = jdBuildDriveList();
         if(!first)
            /* Handle error */
         else
            {
            next = first;
            while(next)
               {
               drive = next->Drive;
               type = (drive > -1) ? 0 : (drive == PHANTOM_B) ? 1 : 2;
               printf("Drive %c is %s\n",
               (drive > -1) ? drive+'A' : '?',*(valid+type));
               next = next->Next;
               }
            }
         /* Since jdDrives[] is static, no need to free it */
         }




         jdFLIB v1.0 - User's Guide and Reference               Page 8
         -------------------------------------------------------------




         =============================================================
         jdBuildDirList                                       jdFLIB.H
         =============================================================

          PROTOTYPE: jdDLIST *BuildDirList(char *mask, int attrib);

         PARAMETERS: mask - pointer to mask string. It may contain
                            drive letter, path and wildcards.

                     attrib - bitwise file attribute flags. See
                              <dir.h> for the meanings of each bit.

             RETURN: Pointer to first in linked list of type jdDLIST.
                     Returns NULL on error or no files.  Check "errno"
                     for cause of error.

         DISCUSSION: This function builds a doubly linked list of
                     structures of type jdDLIST. The contents of this
                     list will depend on the "mask" and "attrib"
                     parameters that you pass to the function. You may
                     parse the list using the node pointers to display
                     or otherwise manipulate.

                     The list will be in ASCII ascending order with
                     directories placed first (if the FA_DIREC bit of
                     "attrib" is set).

                     ALL_ATTR is defined in jdFLIB.H to set all
                     applicable bits.

         EXAMPLE:

         #include <stdio.h>
         #include <stdlib.h>
         #include <dir.h>
         #include "jdFLIB.H"

         void main()
         {
         static char format[] = " %-8s  %-4s    %s    %s   %9ld   %s\n";
         jdDLIST *first, *next;

         first = jdBuildDirList("*.*",ALL_ATTR); /* Show everything */
         if(!first)
            /* Handle error */
         else




         jdFLIB v1.0 - User's Guide and Reference               Page 9
         -------------------------------------------------------------



            {
            next = first;
            while(next) /* Print directory to stdout */
               {
               printf(format,next->Name,next->Ext,next->Date,
                      next->Time,next->Size,jdBuildAttrStr(next));
               next = next->Next;
               }
            }
         jdFreeDirList(first);
         }

         =============================================================
         jdBuildTreeList                                      jdFLIB.H
         =============================================================

          PROTOTYPE: jdTLIST *jdBuildTreeList(int drive);

         PARAMETERS: drive - ordinal drive number, where A = 0, B = 1,
                             C = 2, etc.

             RETURN: Pointer to first in doubly linked list of type
                     jdTLIST. Returns NULL on error (check "errno").

         DISCUSSION: This function builds a list of all directories
                     for the specified drive. Other functions in the
                     library may then be used to access the list. See
                     the jdDEMO program for an example of what the
                     tree looks like when displayed. The list will be
                     in ASCII ascending order by directory level.

         EXAMPLE:

         #include <stdio.h>
         #include <stdlib.h>
         #include "jdFLIB.H"

         void main()
         {
         jdTLIST *first, *next;

         first = jdBuildTreeList(2);  /* Drive C */
         if(!first)
            /* Handle error */
         else
            {
            jdWriteTreeLog(NULL,first,2);  /* Write log to drive C (root) */




         jdFLIB v1.0 - User's Guide and Reference              Page 10
         -------------------------------------------------------------



            next = first;
            while(next) /* Draw tree to stdout */
               {
               printf("%s%s\n",jdConnectTree(next),next->Name);
               next = next->Next;
               }
            next = first;
            while(next)  /* Show path of each node */
               {
               printf("%s\n",jdBuildPath(next,2));
               next = next->Next;
               }
            }
         jdFreeTreeList(first);
         first = jdReadTreeLog(NULL,2); /* Read log from drive C */
         if(!first)
            /* Handle error */
         else
            {
            next = first;
            while(next) /* Draw log tree to stdout */
               {
               printf("%s%s\n",jdConnectTree(next),next->Name);
               next = next->Next;
               }
            next = first;
            }
         jdFreeTreeList(first);
         }

         =============================================================
         jdFreeDirList                                        jdFLIB.H
         =============================================================

          PROTOTYPE: int jdFreeDirList(jdDLIST *first);

         PARAMETERS: first - first in linked list of type jdDLIST as
                             returned by call to jdBuildDirList();

             RETURN: 1 on success, else 0.

         DISCUSSION: This function frees the memory used by the linked
                     list. This memory should be freed when the list
                     is no longer needed.

            EXAMPLE: See jdBuildDirList() above.





         jdFLIB v1.0 - User's Guide and Reference              Page 11
         -------------------------------------------------------------



         =============================================================
         jdFreeTreeList                                       jdFLIB.H
         =============================================================

          PROTOTYPE: int jdFreeTreeList(jdTLIST *first);

         PARAMETERS: first - first in linked list of type jdTLIST as
                             returned by call to jdBuildTreeList();

             RETURN: 1 on success, else 0.

         DISCUSSION: This function frees the memory used by the linked
                     list. This memory should be freed when the list
                     is no longer needed.

            EXAMPLE: See jdBuildTreeList() above.


         =============================================================
         jdConnectTree                                        jdFLIB.H
         =============================================================

          PROTOTYPE: char *jdConnectTree(jdTLIST *node);

         PARAMETERS: node - pointer to the directory node you wish to
                            connect.

             RETURN: Pointer to "connection" string, or NULL on error.

         DISCUSSION: This function returns a string that shows the
                     relationship of the current node to previous
                     nodes. This string can be prefixed to the Name
                     member of the node when displaying the tree.

                     Note that jdConnectTree() uses the predefined
                     strings (declared extern in jdFLIB.H) as follows:

                     char jdBullet[3] = " ";    /* 32 */
                     char jdUpDnRt[4] = " ";  /* 32,199,196 */
                     char jdUpRt[4]   = " ";  /* 32,211,196 */
                     char jdUpDn[4]   = "  ";  /* 32,186,32 */

                     If you are using a graphics mode or any video
                     mode that does not support the IBM extended
                     character set, or simply wish to use other
                     characters in your display, you may replace the
                     string by using strcpy() to change them. The demo




         jdFLIB v1.0 - User's Guide and Reference              Page 12
         -------------------------------------------------------------



                     program jdDEMO.EXE uses the characters as is. The
                     names of the arrays indicate their purpose.

            EXAMPLE: See jdBuildTreeList() above.


         =============================================================
         jdBuildPath                                          jdFLIB.H
         =============================================================

          PROTOTYPE: char *jdBuildPath(jdTLIST *node, int drive);

         PARAMETERS: node  - directory node you wish to build path to.
                     drive - ordinal number of drive to which the jdTLIST
                             list is associated.

             RETURN: Pointer to path string, including drive letter
                     and trailing '\'.  NULL on error.

         DISCUSSION: This functions builds a complete path string from
                     the directory tree node passed to it all the way
                     back to the root.  You may then strcat() a filename
                     or mask to it for whatever your need may be.

                     Note that the path string is static and will be
                     overwritten each time you call jdBuildPath(). Copy
                     the string to another location if you need to
                     keep it around.

            EXAMPLE: See jdBuildTreeList() above.

         =============================================================
         jdBuildAttrStr                                       jdFLIB.H
         =============================================================

          PROTOTYPE: char *jdBuildAttrStr(jdDLIST *node);

         PARAMETERS: node - file node of interested jdDLIST list.

             RETURN: Pointer to attribute string. NULL on error.

         DISCUSSION: This function looks at the Attrib member of the
                     specified node and returns a pointer to a string
                     showing the attributes of the file. The string is
                     in the form:

                     RHSLDA




         jdFLIB v1.0 - User's Guide and Reference              Page 13
         -------------------------------------------------------------




                     where each letter represents a file attribute as
                     follows:

                     R - Read only
                     H - Hidden
                     S - System
                     L - Volume label
                     D - Directory
                     A - Archive

                     If the bit for each attribute is set, the letter
                     will be included.  Otherwise an underscore (_)
                     will takes its place indicating that the bit is
                     not set.  An example of a directory attribute
                     string might be:

                     ____D_

                     A text file attribute might be:

                     _____A

                     Note: the string is static, and will be
                     overwritten each time you call jdBuildAttrStr().

            EXAMPLE: See jdBuildDirList() above.

         =============================================================
         jdWriteTreeLog                                       jdFLIB.H
         =============================================================

          PROTOTYPE: int jdWriteTreeLog(char *name, jdTLIST *lst, int drv);

         PARAMETERS: name - pointer to name of log file (may be NULL).
                     lst  - pointer to *first* node of jdTLIST list.
                     drv  - Ordinal drive number (e.g., C = 2).

             RETURN: Returns 1 on success, else 0.

         DISCUSSION: On a large drive with many directories and files,
                     scanning the drive with jdBuildTreeList() can
                     take a while. For this reason, jdWriteTreeLog()
                     is provided. This function writes a binary
                     representation of the jdTLIST list to the ROOT
                     directory of the specified drive using the
                     default filename "{{TREE}}.LOG" if the "name"




         jdFLIB v1.0 - User's Guide and Reference              Page 14
         -------------------------------------------------------------



                     parameter is set to NULL. If name is not NULL, it
                     is expected to point to a valid path string
                     (including drive letter, path and filename) where
                     you want the log to be written. In this case
                     "drv" will be ignored. For example, if "name"
                     points to the string "C:\MYDIR\LOG\LOGNAME.LOG",
                     then this is where the log will be written.

            EXAMPLE: see jdBuildTreeList() above.


         =============================================================
         jdReadTreeLog                                        jdFLIB.H
         =============================================================

          PROTOTYPE: jdTLIST *jdReadTreeLog(char *name, int drv);

         PARAMETERS: name - pointer to filename of log file.
                     drv  - Ordinal drive number.

             RETURN: Pointer to first in doubly linked list of type
                     jdTLIST.  NULL on error.

         DISCUSSION: The complement of jdWriteTreeLog(). If "name" is
                     NULL, the function will look for the default
                     filename "{{TREE}}.LOG" in the root directory of
                     the specified drive. Otherwise it will look for
                     the path/filename you specify. The list created
                     by this function is identical to the list
                     returned by a call to jdBuildTreeList()
                     (assuming the log is up to date!).

            EXAMPLE: See jdBuildTreeList() above.


         =============================================================
         jdDelDirNode                                         jdFLIB.H
         =============================================================

          PROTOTYPE: jdDLIST *jdDelDirNode(jdDLIST *d_item);

         PARAMETERS: d_item - Pointer to node in list.

             RETURN: Pointer to next (d_item->Next) or last item in
                     the list of which d_item is a member. NULL on
                     failure.





         jdFLIB v1.0 - User's Guide and Reference              Page 15
         -------------------------------------------------------------



         DISCUSSION: This function will delete the node pointed to by
                     d_item, free the memory used by the node, and
                     adjust the node links to remove it from the list.
                     (See discussion of jdDLIST structure above.) Note
                     that this function will not delete a node if the
                     filename associated with the node is a directory
                     (i.e., has the _A_SUBDIR bit set in the Attrib
                     member). The jdDelTreeNode() function should be
                     used for deleting directories.

                     This function exists for maintaining lists of
                     type jdDLIST. It DOES NOT delete the file on
                     disk. You have to do that yourself, and only
                     delete the node if you are successful. Other than
                     refusing to delete a directory node, this
                     function assumes you know what you are doing.

            EXAMPLE: See jdDEMO.C

         =============================================================
         jdAddDirNode                                         jdFLIB.H
         =============================================================

          PROTOTYPE: jdDLIST *jdAddDirNode(jdDLIST *d, jdDLIST *d_item);

         PARAMETERS: d - Pointer to first in list of type jdDLIST.
                     d_item - Pointer to node in list.

             RETURN: Pointer to first of same list. NULL on failure.

         DISCUSSION: This function adds "d_item" to the list "d."
                     It is assumed that d_item is initialized with the
                     data pertaining to the file it represents (see
                     the discussion of the jdDLIST structure above).
                     This function will not add a node if the Attrib
                     member has the _A_SUBDIR bit set. The node will
                     be added to the list in ASCII ascending order
                     based on the contents of Name and Ext.

                     This function exists for maintaining lists of
                     type jdDLIST. It DOES NOT create the file on
                     disk. You have to do that yourself, and only
                     add the node if you are successful. Other than
                     refusing to add a directory node, this function
                     assumes you know what you are doing.

                     Note: An easy way to get an initialized jdDLIST




         jdFLIB v1.0 - User's Guide and Reference              Page 16
         -------------------------------------------------------------



                           struct is to call jdBuildDirList() with
                           "mask" pointing the filename (with path, if
                           needed) and "attrib" set to 0. This will
                           return a list of one item. A pointer to
                           this item may then be passed to
                           jdAddDirNode().

            EXAMPLE: See jdDEMO.C

         =============================================================
         jdDelTreeNode                                        jdFLIB.H
         =============================================================

          PROTOTYPE: jdTLIST *jdDelTreeNode(jdTLIST *t_item);

         PARAMETERS: t_item - Pointer to node to delete.

             RETURN: Pointer to next (t_item->Next) or last item
                     in list. NULL on error.

         DISCUSSION: This function deletes the node "t_item" from the
                     list of which it is a member, frees the memory
                     used by the node, and adjust the node links to
                     remove it from the list. It will refuse to delete
                     the node if t_item has sub-directories. It DOES
                     NOT check to see if the directory has files. It
                     is HIGHLY recommended that you use this function
                     to delete nodes, since the jdTLIST structure has
                     no less than four pointers that must be adjusted
                     properly, or other functions in the library may
                     fail.

                     This function exists for maintaining lists of
                     type jdTLIST. It DOES NOT delete the directory on
                     disk. You have to do that yourself, and only
                     delete the node if you are successful. Other than
                     refusing to delete a node with sub-dirs, this
                     function assumes you know what you are doing.

            EXAMPLE: See jdDEMO.C


         =============================================================
         jdAddTreeNode                                        jdFLIB.H
         =============================================================

          PROTOTYPE: jdTLIST *jdAddTreeNode(jdTLIST *parent, char *name);




         jdFLIB v1.0 - User's Guide and Reference              Page 17
         -------------------------------------------------------------




         PARAMETERS: parent - Pointer to parent node (the added node
                              will be a sub-directory of parent).
                     name - Pointer to directory name of node to be
                            added.

             RETURN: Pointer to created node or NULL on error. This
                     function will fail if "name" has more than 12
                     characters (i.e., <8><.><3>) and "errno" will be
                     set to 14 (invalid data).

         DISCUSSION: This function adds a tree node called "name" and
                     makes it a sub-directory of "parent." The node
                     will be added in ASCII ascending order. It is
                     HIGHLY recommended that you use this function
                     to add nodes, since the jdTLIST structure has
                     no less than four pointers that must be adjusted
                     properly, or other functions in the library may
                     fail.

                     This function exists for maintaining lists of
                     type jdTLIST. It DOES NOT create the directory on
                     disk. You have to do that yourself, and only
                     add the node if you are successful. This function
                     assumes you know what you are doing.

            EXAMPLE: See jdDEMO.C

         =========================== END =============================
