/*
   JDFLIB.H  Header for JDFLIB.LIB
   Copyright 1993 James C. Dunavant, All Rights Reserved
*/

#ifndef __jdFLIB_H
#define __jdFLIB_H
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int jdHardRetry;   /* Set true on critical error "Retry" */
extern char jdBullet[3];  /* 32 */
extern char jdUpDnRt[4];  /* 32,199,196 */
extern char jdUpRt[4];    /* 32,199,196 */
extern char jdUpDn[4];    /* 32,186,32 */
extern char jdSpc[4];     /* 32,32,32 */

/* Directory list */
typedef struct Dlist {
   struct Dlist *Next;  /* Next node pointer */
   struct Dlist *Prev;  /* Previous node pointer */
   char Name[9];        /* File/dir name */
   char Ext[5];         /* Extension */
   char Time[9];        /* Time string */
   char Date[9];        /* Date string */
   int Attrib;          /* File attributes */
   long Size;           /* Size in bytes */
   unsigned Flags;      /* User flags--not used by jdFiles */
   } jdDLIST;

#define ALL_ATTR 0x003F

/* Directory tree list */
typedef struct Tlist {
   struct Tlist *Next;    /* Next node pointer */
   struct Tlist *Prev;    /* Previous node pointer */
   struct Tlist *Parent;  /* Parent to this directory */
   struct Tlist *ASib;    /* Next adjacent sibling */
   int Level;             /* Level relative to root; root = 0 */
   char Name[13];         /* Directory name */
   unsigned Flags;        /* User flags--not used by jdFiles */
   } jdTLIST;

/* Active drive log list */
typedef struct Llist {
    struct Llist *Next;   /* Links */
    struct Llist *Prev;
    struct Tlist *Tree;   /* Pointer to Tree list for this drive */
    unsigned Remote;      /* Bitwise network flags */
    unsigned Cdrom;       /* Set to true if cdrom drive */
    int Drive;            /* A = 0, B = 1, C = 2, etc. */
    void *User;           /* Pointer to user data */
    } jdLLIST;

extern jdLLIST jdDrives[26];

#define INV_DRIVE -1   /* Can log on to this drive */
#define PHANTOM_B -2   /* No physical B drive */

#define IS_UNKNOWN    0x0000   /* Details of drive unknown */
#define IS_REMOTE     0x1000   /* Remote drive on network */
#define IS_SHARED     0x0200   /* Local drive, shared on network */
#define IS_SUBSTITUTE 0x8000   /* Substituted drive (e.g., SUBST) */

/* Prototypes */
jdLLIST * cdecl jdBuildDriveList(void);
jdDLIST * cdecl jdBuildDirList(char *mask, int attrib);
jdTLIST * cdecl jdBuildTreeList(int drive);
char * cdecl jdConnectTree(jdTLIST *tlist);
char * cdecl jdBuildPath(jdTLIST *tlist, int drive);
int cdecl jdWriteTreeLog(char *name, jdTLIST *tlist, int drive);
jdTLIST * cdecl jdReadTreeLog(char *name, int drive);
int cdecl jdFreeDriveList(jdLLIST *llist);
int cdecl jdFreeDirList(jdDLIST *dlist);
int cdecl jdFreeTreeList(jdTLIST *tlist);
char * cdecl jdBuildAttrStr(jdDLIST *t_item);
jdDLIST * cdecl jdDelDirNode(jdDLIST *d_item);
jdDLIST * cdecl jdAddDirNode(jdDLIST *dlist, jdDLIST *d_item);
jdTLIST * cdecl jdDelTreeNode(jdTLIST *t_item);
jdTLIST * cdecl jdAddTreeNode(jdTLIST *parent, char *name);

#ifdef __cplusplus
}
#endif
