		PAGE		,132
		TITLE		Windows Check Function

		.MODEL		large,c	; change as appropriate for your system

		COMMENT	$
	int _iswinup (void);
		Slightly modified from Microsoft Systems Journal Code
		March 1991 - To run under Microsoft c 5.1 (or 6.0)
		A. L. Bender, M. D.
		PO Box 8685
		Woodcliff Lake, NJ 07675-8685

	Modifications are public domain
	Assemble under: masm /Mx iswinup,,;

	This function makes a test to determine if the user is running under
	any of the Microsoft Windows (TM) software.

	It  returns zero if no windows are up and running.
	Returns 1 if running Windows/386 2.x is running
	Returns 3 if running Windows/386 3.x is running in enhanced mode
	Returns 4 if running Windows/386 4.x is running in enhanced mode
	Returns 127 if running Windows/386 2.x
	Returns 128 if running Windows/386 3.x in real mode
	Returns 255 if running Windows/386 3.x in standard mode

	Proper use is:
	extern int iswinup(void);
	;;;;
	if (iswinup())
		windows is up
	else
		windows isn't up
	

	$

MPXINT		EQU		2FH		; Multiplex interrupt
		.CODE				; Only has code segment
iswinup		PROC
		MOV		AX,4680H	; Windows 3.0 standard or real
		INT		MPXINT
		XOR		AL,80H		; toggle not running bit
		MOV		CL,AL
		MOV		AX,1600H	; Windows/386 Enhanced Mode?
		INT		MPXINT
		AND		AL,7FH
		OR		AL,CL
		CMP		AL,80H
		JZ		simulate
		XOR		AX,AX		; Windows not running, get out
		RET				; right now
simulate:	PUSH		SI		; Further tests, save regs from
		PUSH		ES		; ruin
		MOV		AX,1605H	; simulate initialization
						; under windows
		XOR		BX,BX
		MOV		ES,BX
		XOR		SI,SI
		PUSH		DS
		MOV		DS,SI
		XOR		CX,CX
		MOV		DX,1
		INT		MPXINT		; Is windows running?
		CMP		CX,0		; cx=FFFF windows running
		JNZ		skipout		; not running
		MOV		AX,1606H
		INT		MPXINT		; get out of windows, proved your point
skipout:	MOV		AL,80H
		OR		AL,CL
		AND		AX,00FFH	; mask off trash bits
		POP		DS
		POP		ES
		POP		SI
		RET				; return to user code
iswinup		ENDP
		END
