#if !defined( __HANDLER_H )
#define __HANDLER_H

/********************************************************************/
/*	File: 			Handler.h                                       */
/*	Author:			Patrick Reilly                                  */
/*	Compuserve ID:	70274,161                                       */
/*	Date:			10/27/92                                        */
/*                                                                  */
/*	Note: this file, and handler.cpp, are open to the public domain	*/
/*		under the following condition: publication of the code		*/
/*		contained in either of these two files must not be modified	*/
/*		and credit to the author must be retained.					*/
/********************************************************************/

/********************************************************************/
/*	struct HandlerRegs                                              */
/*                                                                  */
/*	Description                                                     */
/*		This structure encapsulates the registers passed to and		*/
/*	returned by the interrupt service routine (ISR). A pointer to	*/
/*	this structure is passed to the owning instance's handler()		*/
/*	method. If you change the values of the members of this struct,	*/
/*	this is the same as changing the registers returned by the ISR.	*/
/********************************************************************/

struct HandlerRegs
	{
	unsigned bp, di, si, ds, es, dx, cx, bx, ax, ip, cs, flags;
	};

/********************************************************************/
/*	Class Handler													*/
/*																	*/
/*	Description														*/
/*		Handler encapsulates an ISR class that is instance-specific.*/
/*  This means that different instances of Handler can service 		*/
/*	different interrupts.											*/
/*																	*/
/*	Methods															*/
/*		Handler		constructor										*/
/*          Initializes the members of Handler.						*/
/*																	*/
/*		~Handler	destructor										*/
/*			Un-installs the ISR (if it is installed) and cleans up.	*/
/*                                                                  */
/*		installedTo													*/
/*          Returns the number of the interrupt that Handler is		*/
/*			currently installed to (if installed).					*/
/*                                                                  */
/*		installed													*/
/*			Returns 0 if this instance is not installed to a		*/
/*			interrupt, otherwise non-zero.							*/
/*                                                                  */
/*      install                                                     */
/*			Installs this instance as an ISR to interrupt aIntno.	*/
/*          When the interrupt occurs, this instance's handler()	*/
/*			will be called, then the interrupt ends.				*/
/*                                                                  */
/*		chain                                                       */
/*			Installs this instance as an ISR to interrupt aIntno.	*/
/*			When the interrupt occurs, this instance's handler()	*/
/*			will be called, then chains to the previous interrupt	*/
/*			handler for this interrupt (the handler that was in 	*/
/*			place when chain() was called).							*/
/*                                                                  */
/*		uninstall                                                   */
/*			Replaces the original ISR (the one in place when either	*/
/*			install() or chain() was called).						*/
/*                                                                  */
/*      handler														*/
/*			Pure abstract method that is called when the interrupt	*/
/*			occurs. Must be overridden to perform the ISR function.	*/
/*          The HandlerRegs structure received by this method hold	*/
/*			the values of the CPU registers when the interrupt		*/
/*			occurred; changing these values will change the values	*/
/*			of the CPU registers when the interrupt ends.			*/
/********************************************************************/

class Handler
	{
	public:

		Handler();
		~Handler();

		int installedTo();
		int installed();
		int install( int aIntno );
		int chain( int aIntno );
		void uninstall();

		virtual void far handler( HandlerRegs far * ) = 0;

	protected:

		char *buf;
		int intno;
		void  interrupt far (*oldisr)(...);

		int do_install( int aIntno, int useChain );
		static void interrupt far stdisr( unsigned, ... );
		static void interrupt far chainisr( unsigned, ... );
	};

#endif
