#include "handler.h"
#include <dos.h>
#include <mem.h>

/********************************************************************/
/*	File: 			Handler.cpp                                     */
/*	Author:			Patrick Reilly                                  */
/*	Compuserve ID:	70274,161                                       */
/*	Date:			10/27/92                                        */
/*                                                                  */
/*	Note: this file, and handler.h, are open to the public domain	*/
/*		under the following condition: publication of the code		*/
/*		contained in either of these two files must not be modified	*/
/*		and credit to the author must be retained.					*/
/********************************************************************/

// DO NOT MESS WITH THESE!
const	isrSize =	0x0052,
		isrSeg =	0x0016,
		isrOff =	0x001B;

Handler::Handler() :
		buf(0),
		intno(-1),
		oldisr(0)
	{
	}

Handler::~Handler()
	{
	uninstall();
	}

int Handler::installedTo()
	{
	return intno;
	}

int Handler::installed()
	{
	return (buf != 0);
	}

void Handler::uninstall()
	{
	if( installed() )
		{
		setvect( intno, oldisr );
		delete buf;
		oldisr = 0;
		buf = 0;
		intno = -1;
		}
	}

int Handler::install( int aIntno )
	{
	return do_install( aIntno, 0 );
	}

int Handler::chain( int aIntno )
	{
	return do_install( aIntno, 1 );
	}

// DO NOT MESS WITH THIS!
int Handler::do_install( int aIntno, int useChain )
	{
	if( installed() )
		return 0;

	buf = new char [isrSize];
	if( buf == 0 )
		return 0;
	if( useChain )
		_fmemcpy( buf, chainisr, isrSize );
	else
		_fmemcpy( buf, stdisr, isrSize );

	*((unsigned short *)(buf+isrSeg)) = FP_SEG(this);
	*((unsigned short *)(buf+isrOff)) = FP_OFF(this);

	intno = aIntno;
	oldisr = getvect(intno);
	setvect( intno, ( void interrupt far (*)(...) ) buf );
	return 1;
	}

// OR THIS!
void interrupt far Handler::stdisr(unsigned bp, ... )
	{
	Handler far *hptr;
	asm	mov	word ptr [hptr+2], 0
	asm mov word ptr [hptr], 0
	hptr->handler( (HandlerRegs far *) &bp );
	}

// OR THIS!
void interrupt far Handler::chainisr(unsigned bp, ... )
	{
	Handler far *hptr;
	asm	mov	word ptr [hptr+2], 0
	asm mov word ptr [hptr], 0
	hptr->handler( (HandlerRegs far *) &bp );
	_chain_intr( hptr->oldisr );
	}