/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* A replacer for the MSDOS functions.					     *
*****************************************************************************/

#ifndef __MSDOS__

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "program.h"
#include "allocatg.h"

#ifdef BSD43

/*****************************************************************************
*   Get current working directory - BSD4.3.				     *
*****************************************************************************/
char *getcwd(char *s, int Len)
{
    getwd(s);

    return s;
}

#endif /* BSD43 */

/*****************************************************************************
*   Routine to concat a full path to a given name - used in non MSDOS        *
* environment only, and in that case assumes path is in IRIT_PATH variable.  *
*****************************************************************************/
char *searchpath(char *Name)
{
    static char FullPath[LINE_LEN];
    char *p;

    if ( p = getenv("IRIT_PATH") ) {
	strcpy(FullPath, p);
	strcat(FullPath, Name);
    }
    else {
	strcpy(FullPath, Name);
    }
    return FullPath;
}

/*****************************************************************************
*   Routine to compare tow strings, ignoring case, up to given length.       *
*****************************************************************************/
int strnicmp(char *s1, char *s2, int n)
{
    return strncasecmp(s1, s2, n);
}

/*****************************************************************************
*   Routine to search for pattern (no regular expression) in s. Returns      *
* address in s of first occurance of patern, NULL if non found.		     *
*****************************************************************************/
char *strstr(char *s, char *Pattern)
{
    int Len = strlen(Pattern);
    char *p = s;
    
    while (p = strchr(p, Pattern[0]))
	if (strncmp(p, Pattern, Len) == 0) return p;
        else p++;

    return NULL;
}

/*****************************************************************************
*   Routine to compare to strings, ignoring their case.			     *
*****************************************************************************/
int stricmp(char *s1, char *s2)
{
    int i;
    char *u1, *u2;

    if (s1 == NULL) return -(s2 == NULL);
    else
    if (s2 == NULL) return 1;

    u1 = strdup(s1);
    u2 = strdup(s2);

    for (i = 0; i < strlen(u1); i++) if (islower(u1[i])) u1[i] = toupper(u1[i]);
    for (i = 0; i < strlen(u2); i++) if (islower(u2[i])) u2[i] = toupper(u2[i]);

    i = strcmp(u1, u2);

    MyFree(u1, OTHER_TYPE);
    MyFree(u2, OTHER_TYPE);

    return i;
}

#ifndef SYSV
/*****************************************************************************
*   Routine to compare to strings, ignoring their case.			     *
*****************************************************************************/
char *strdup(char *s)
{
    char *p;

    if (p == NULL) return NULL;

    p = MyMalloc(strlen(s) + 1, OTHER_TYPE);

    strcpy(p, s);

    return p;
}
#endif /* SYSV */

/*****************************************************************************
*   Routine to move a block in memory. Unlike memcpy/bcopy, this routine     *
* should support overlaying blocks. This stupid implemetation will copy it   *
* twice - to a temporary block and back again. The temporary block size will *
* be allocated by demand.						     *
*****************************************************************************/
void movmem(VoidPtr Src, VoidPtr Dest, int Len)
{
    VoidPtr p = MyMalloc(Len, OTHER_TYPE);

    memcpy(p, Src, Len);
    memcpy(Dest, p, Len);

    MyFree(p, OTHER_TYPE);
}

#endif /* __MSDOS__ */
