/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions of primitiv module.		     *
*****************************************************************************/

#ifndef	PRIMITIVE_LH
#define	PRIMITIVE_LH

#define	MIN_RESOLUTION 4

static int GetResolution(void);
static struct PolygonStruct *GenInsidePoly(PolygonStruct *Pl);
static struct PolygonStruct *GenPolygon4Vrtx(VectorType V1, VectorType V2,
	VectorType V3, VectorType V4, VectorType Vin, PolygonStruct *Pnext);
static struct PolygonStruct *GenPolygon3Vrtx(VectorType V1, VectorType V2,
			VectorType V3, VectorType Vin, PolygonStruct *Pnext);
static void GenTransformMatrix(MatrixType Mat, VectorType Trans,
						VectorType Dir, RealType Scale);

#endif	/* PRIMITIVE_LH */
