/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   General, local to module, definitions for the Input Parser module.	     *
*   Note this module actually consists of InptPrsr/InptEval/OverLoad modules.*
*****************************************************************************/

#ifndef	INPT_PRSR_LH
#define	INPT_PRSR_LH

/* #define DEBUG        Print some intermediate results (InptPrsr/InptEval). */

#define MAX_PARSER_STACK	200	     /* Depth of expression nesting. */

#define GEOMETRIC_EXPR	GEOMETRIC_OBJ
#define NUMERIC_EXPR	NUMERIC_OBJ
#define VECTOR_EXPR	VECTOR_OBJ
#define MATRIX_EXPR	MATRIX_OBJ
#define	STRING_EXPR	STRING_OBJ
#define OBJ_LIST_EXPR	OBJ_LIST_OBJ

#define NON_EXPR	99		      /* Nothing should be returned! */
#define ERROR_EXPR	-1					 /* Error... */

#define ANY_OBJ		100	 /* Match any object type, in type checking. */

extern int IPGlblEvalError;			 /* Global used by EvalTree. */

/*****************************************************************************
* The expression parse tree node definition:				     *
*****************************************************************************/
typedef	struct ParseTree {
    struct ParseTree *Right, *Left;
    int NodeKind;
    int ObjType;
    union {
	RealType R;
	struct ObjectStruct *PObj;
    } U;
} ParseTree;

/* See Irit.h file for the different object possible: */
#define IS_GEOM_NODE(Node)	((Node)->ObjType == GEOMETRIC_OBJ)
#define IS_NUM_NODE(Node)	((Node)->ObjType == NUMERIC_OBJ)
#define IS_VEC_NODE(Node)	((Node)->ObjType == VECTOR_OBJ)
#define IS_MAT_NODE(Node)	((Node)->ObjType == MATRIX_OBJ)
#define IS_STR_NODE(Node)	((Node)->ObjType == STRING_OBJ)
#define IS_OLST_NODE(Node)	((Node)->ObjType == OBJ_LIST_OBJ)

/*****************************************************************************
* The include file stack - nesting is allowed up to FILE_STACK_SIZE.	     *
*****************************************************************************/
typedef struct FileStackStruct {
    char Name[FILE_NAME_LEN];
    FILE *f;
} FileStackStruct;

#define FILE_STACK_SIZE	10

/*****************************************************************************
* Aliases are simple strings substitution - each entry holds alias Name and  *
* alias Value, which replaces Name. Name id not NULL if active.		     *
*****************************************************************************/
typedef struct OneAliasStruct {
    char *Name, *Value;
} OneAliasStruct;

#define NUM_OF_ALIASES	10

typedef struct AliasesStruct {
    OneAliasStruct Aliases[NUM_OF_ALIASES];
} AliasesStruct;

/*****************************************************************************
* Function entry table looks like this (for table see InptPrsr.c module):    *
*****************************************************************************/
#define FUNC_NAME_LEN	11			    /* 10 + NULL terminator. */
#define NUM_FUNC_MAX_PARAM 2 /* Max. of 2 params. for real returned function.*/
#define OBJ_FUNC_MAX_PARAM 4 /* Max. of 4 params. for obj. returned function.*/
#define GEN_FUNC_MAX_PARAM 4 /* Max. of 4 params. for gen. returned function.*/

#define ANY_PARAM_NUM	127

typedef struct NumFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    double (*Func)();
    ByteType NumOfParam;
    ByteType ParamObjType[NUM_FUNC_MAX_PARAM];
} NumFuncTableType;

typedef struct ObjFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    ObjectStruct *(*Func)();
    ByteType NumOfParam;
    ByteType ParamObjType[OBJ_FUNC_MAX_PARAM];
} ObjFuncTableType;

typedef struct GenFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    void (*Func)();
    ByteType NumOfParam;
    ByteType ParamObjType[GEN_FUNC_MAX_PARAM];
} GenFuncTableType;

typedef struct ConstantTableType {
    char FuncName[FUNC_NAME_LEN];
    RealType Value;
} ConstantTableType;

/* The followings are defined in the InptEval.c module and are globals so   */
/* InptPrsr.c module will be able to access them...			    */
extern NumFuncTableType NumFuncTable[];
extern int NumFuncTableSize;
extern ObjFuncTableType ObjFuncTable[];
extern int ObjFuncTableSize;
extern GenFuncTableType GenFuncTable[];
extern int GenFuncTableSize;
extern ConstantTableType ConstantTable[];
extern int ConstantTableSize;

/*****************************************************************************
* Tokens used in the expression	to tree	conversion and tree definition.	     *
*****************************************************************************/

#define	TOKENERROR  0
#define TOKENSTART  1
#define TOKENEND    2

#define	OPENPARA    10					     /* Paranthesis. */
#define	CLOSPARA    11

#define	NUMBER	    20					    /* Numeric Data. */
#define	PARAMETER   30				 /* Point on new/old object. */
#define STRING	    40	     /* Sequence of characters within double quotes. */

/* Warning - changing the order of these constants, needs updating the order */
/* of them, in the tables in the begining of InptPrsr.c & OverLoad.c modules.*/

#define	ARCCOS	    100			   /* Real value returned functions. */
#define	ARCSIN	    101
#define	ARCTAN2	    102
#define	ARCTAN	    103
#define	COS	    104
#define	EXP	    105
#define	FABS	    106
#define	LN	    107
#define	LOG	    108
#define	SIN	    109
#define	SQRT	    110
#define	TAN	    111
#define CPOLY	    112
#define AREA	    113
#define VOLUME      114
#define TIME	    115

#define NUM_FUNC_OFFSET	100
#define IS_NUM_PROCEDURE(Token)		(Token >= 100 && Token < 200)

#define VECTOR	    200			       /* Object returned Functions. */
#define ROTX	    201
#define ROTY	    202
#define ROTZ	    203
#define TRANS	    204
#define SCALE	    205
#define BOX	    206
#define GBOX	    207
#define CONE	    208
#define CYLIN	    209
#define SPHERE	    210
#define TORUS	    211
#define PLANE	    212
#define POLY	    213
#define CROSSEC	    214
#define SURFREV     215
#define EXTRUDE     216
#define LIST	    217
#define LOAD	    218
#define CONVEX	    219

#define OBJ_FUNC_OFFSET	200
#define IS_OBJ_PROCEDURE(Token)		(Token >= 200 && Token < 300)

#define EXIT	    300	  /* General Functions/No value returned procedures. */
#define VIEW	    301
#define DIR	    302
#define CHDIR	    303
#define NORMAL	    304
#define INCLUDE	    305
#define GDUMP       306
#define MDUMP       307
#define FREEOBJ     308
#define INTERACT    309
#define PAUSE	    310
#define IFCOND	    311
#define FORLOOP	    312
#define PRHELP	    313
#define VARLIST	    314
#define ALIAS	    315
#define BEEP	    316
#define EDIT	    317
#define SYSTEM	    318
#define LOGFILE	    319
#define COLOR	    320

#define COMMENT	    399

#define GEN_FUNC_OFFSET	300
#define IS_GEN_PROCEDURE(Token)		(Token >= 300 && Token < 400)

#define IS_PROCEDURE(Token)		(Token >= 100 && Token < 400)
#define IS_NO_PARAM_PROC(Token)		(Token == EXIT || Token == SYSTEM || \
					 Token == VARLIST)


#define	PLUS	    400					       /* Operators. */
#define	MINUS	    401
#define	MULT	    402
#define	DIV	    403
#define	POWER	    404
#define	UNARMINUS   405
#define EQUAL	    406
#define COMMA	    407
#define COLON	    408
#define SEMICOLON   409

#define OPERATORS_OFFSET	400

/*****************************************************************************
*   The local function (static) prototypes:				     *
*   Note that if DEBUG is defined for the preprocessor, few more function    *
* become available:							     *
*   Also note that some of the routines are defined globals as both the      *
* InptPrsr.c and InptEval.c modules needs them.				     *
*****************************************************************************/
/* Main parser routine (operator preceedence): Input stream to bin-tree. */
ParseTree *MyExprMalloc(void);
void MyExprFree(ParseTree *Ptr);
void UpdateCharError(char *StrMsg, int Token);
void AliasEdit(char *Name, char *Value);
void AliasExpand(char *Line);
void FileInclude(char *FileName);
int InptPrsrTypeCheck(ParseTree *Root, int Level);	 /* Type check tree. */
struct ParseTree *InptPrsrEvalTree(ParseTree *Root,
					       int Level); /* Evaluate tree. */
void InptPrsrFreeTree(ParseTree *Root);			   /* Free all tree. */
void InptPrsrPrintTree(ParseTree *Root, char *str);	      /* print it... */
ParseTree *InptPrsrCopyTree(ParseTree *Root);			 /* Copy it. */

#endif	/* INPT_PRSR_LH */
