/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions of polygon adjacencies module.       *
*****************************************************************************/

#ifndef	ADJACENCY_LH
#define	ADJACENCY_LH

#define HASH_TABLE_SIZE  100
#define HASH_TABLE_SIZE1 101			     /* One above the above. */
#define HASH_TABLE_SIZE2 50			       /* Half of the above. */

typedef struct HashTableEntry {
    int Key;
    struct PolygonStruct *Pl;
    struct VertexStruct *V;
    struct HashTableEntry *Pnext;
} HashTableEntry;

typedef struct HashTableStruct {
    struct HashTableEntry *Entry[HASH_TABLE_SIZE1];
} HashTableStruct;

/* Prototypes of local function of adjacecies module: */
static void InsertHashTable(HashTableStruct *HashTbl, PolygonStruct *Pl,
							VertexStruct *V);
static int EdgeKey(VertexStruct *V);
static HashTableEntry *FindMatchEdge(HashTableStruct *HashTbl, int EntryNum,
							HashTableEntry *PHash);
static int SameEdges(PointType V1E1, PointType V2E1,
		     PointType V1E2, PointType V2E2);

static void InsertSecondHashTable(HashTableStruct *SecondHashTbl,
							HashTableEntry *PHash);
static void SecondEdgeKey(VertexStruct *V, int *Key1, int *Key2);
static HashTableEntry *FindSecondMatchEdge(HashTableStruct *SecondHashTbl,
					int EntryNum, HashTableEntry *PHash);
static int TestSameDir(PointType Pt11, PointType Pt12,
			PointType Pt21, PointType Pt22);
static void DeleteHashTable(HashTableStruct *SecondHashTable,
						VertexStruct *V, int EntryNum);

#endif	/* ADJACENCY_LH */
