/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, visible to others, definitions for the windows module.	     *
*****************************************************************************/

#ifndef	WINDOWS_GH					 /* Define only once */
#define	WINDOWS_GH

#define NO_COLOR	999		    /* Used by WndwInputWindowPutStr */

/* Generic window structure - the equal part of the window structures:       */
/*   Following definition must confirm with the full window definitons as    */
/* defined in WindowsL.H header files!					     */
typedef struct GenerWindowStruct {	   /* The internal window structures */
    int WindowName;			    /* Name of window (unique index) */
    RealType MinX, MaxX, MinY, MaxY;       /* Note they differ only in the   */
    int FrameColor, LineColor, TextColor;    /* last component - Lines.	     */
    int NumOfLines;
    RealType FirstLineX, FirstLineY, DiffYLine;
} GenerWindowStruct;

/* Prototypes of the windows module functions: */
#ifdef __MSDOS__
void WndwClaimStatus(void);
void WndwReclaimStatus(void);
void WndwStatusWindowDraw(void);
void WndwStatusWindowUpdate(void);
#endif /* __MSDOS__ */

void WndwPause(RealType *R);
char WndwInputWindowPause(double X, double Y);
void WndwLogPrint(RealType *Set);
void WndwInputWindowPutStrFS(char *str, int Color, int Reset);
void WndwInputWindowPutStr(char *str, int Color);
void WndwInputWindowGetStr(char *str, int Length);
void WndwSetUpAllWndws(void);
void WndwDrawAllWndwFrames(void);
void WndwViewGeomObject(ObjectStruct *PObj, RealType *ClearWindow);
void WndwClearWindow(GenerWindowStruct *Window);

extern struct GenerWindowStruct *GlblInputWindow, *GlblViewWindow,
							*GlblStatusWindow;

#endif	/* WINDOWS_GH */
