/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   General, visible to others, definitions of Objects module.		     *
*****************************************************************************/

/*****************************************************************************
*   Prototype for visible function in the Objects module.		     *
*****************************************************************************/

#ifndef	OBJECTS_H
#define	OBJECTS_H

void SetUpPredefObjects(void);
struct ObjectStruct *GetObject(char *ObjName);
void FreeObject(ObjectStruct *PObj);
void DeleteObject(ObjectStruct *PObj, int Free);
void InsertObject(ObjectStruct *PObj);
void PrintObject(ObjectStruct *PObj);
void PrintObjectList(ObjectStruct *PObj);
void SetGeomObjectColor(ObjectStruct *PObj, RealType *Color);
struct ObjectStruct *GenGeomObject(char *Name, PolygonStruct *Pl,
							ObjectStruct *Pnext);
struct ObjectStruct *GenNumObject(char *Name, RealType *R,
							ObjectStruct *Pnext);
struct ObjectStruct *GenVecObject(char *Name, RealType *Vec0, RealType *Vec1,
					RealType *Vec2, ObjectStruct *Pnext);
struct ObjectStruct *GenMatObject(char *Name, MatrixType Mat,
							ObjectStruct *Pnext);
struct ObjectStruct *CopyObject(ObjectStruct *Dest, ObjectStruct *Src,
								int CopyAll);
struct VertexStruct *CopyVList(VertexStruct *Src);
struct PolygonStruct *CopyPolygonList(PolygonStruct *Src);

#endif	/* OBJECTS_H */

