/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions of GraphGen module.		     *
*****************************************************************************/

#ifndef	GRAPH_GENERAL_LH				/* Define only once. */
#define	GRAPH_GENERAL_LH

#define	CURSOR_IMAGE_X  24			       /* Cursor dimensions. */
#define	CURSOR_IMAGE_Y  24

#define	POINT_SIZE 0.05				  /* Size of + marker drawn. */
#define	POINT_TITLE 0.02       /* Distance between point title and + marker. */

/* And finally the static (internal) function prototypes: */

static int GGUpdateGetPointKbd(int *x, int *y);
static int GGGetKey(void);

#define KEY_LEFT     256	 /* Key Codes returned for operational keys. */
#define KEY_RIGHT    257
#define KEY_UP	     258
#define KEY_RETURN   259
#define KEY_DELETE   260
#define KEY_INSERT   261
#define KEY_BSPACE   262
#define KEY_ESC      263
#define KEY_HOME     264
#define KEY_END      265

#endif	/* GRAPH_GENERAL_LH */
