/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* Definitions, visible to others, of the dynamic allocator module.	     *
*****************************************************************************/

#ifndef	ALLOCATE_GH
#define	ALLOCATE_GH

char *MyMalloc(unsigned int Size, int Type);
void MyFree(char *p, int Type);

struct VertexStruct * AllocVertex(ByteType Count, ByteType Tags,
				PolygonStruct * PAdj, VertexStruct * Pnext);
struct PolygonStruct * AllocPolygon(ByteType Count, ByteType Tags,
				VertexStruct * V, PolygonStruct * Pnext);
struct ObjectStruct * AllocObject(char *Name, ByteType ObjType,
						 ObjectStruct * Pnext);

#endif	/* ALLOCATE_GH */
