/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions for the windows module.		     *
*****************************************************************************/

#ifndef	WINDOWS_LH					/* Define only once. */
#define	WINDOWS_LH

#define IW_MIN_X	-0.97				/* The INPUT window. */
#define IW_MAX_X	2.0
#define IW_MIN_Y	-0.98
#define	IW_MAX_Y	-0.5
#define IW_FRAME_COLOR	LIGHTCYAN
#define IW_LINE_COLOR	GREEN
#define IW_TEXT_COLOR	GREEN
#define IW_NUM_OF_LINES	6
#define IW_FIRST_LINE_X	IW_MIN_X+0.02
#define IW_FIRST_LINE_Y	IW_MAX_Y-0.02
#define IW_DIFF_Y_LINE	0.065


#define SW_MIN_X	1.2			       /* The STATUS window. */
#define SW_MAX_X	2.0
#define SW_MIN_Y	-0.4
#define	SW_MAX_Y	0.97
#define SW_FRACE_COLOR	LIGHTRED
#define SW_LINE_COLOR	LIGHTMAGENTA
#define SW_TEXT_COLOR	LIGHTMAGENTA
#define SW_NUM_OF_LINES	8
#define SW_FIRST_LINE_X	SW_MIN_X+0.05
#define SW_FIRST_LINE_Y	SW_MAX_Y-0.06
#define SW_DIFF_Y_LINE	0.09
#define CORE_SIZE_X	0.2
#define CORE_SIZE_Y	0.05

#define VW_MIN_X	-0.97				 /* The VIEW window. */
#define VW_MAX_X	1.1
#define VW_MIN_Y	-0.4
#define	VW_MAX_Y	0.97
#define VW_FRACE_COLOR	LIGHTGREEN
#define VW_LINE_COLOR	GREEN
#define VW_TEXT_COLOR	GREEN
#define VW_NUM_OF_LINES	1
#define VW_FIRST_LINE_X	VW_MIN_X+0.05
#define VW_FIRST_LINE_Y	VW_MIN_Y+0.05
#define VW_DIFF_Y_LINE	0.08

/*   Following definitions must confirm with the generic window defined in   */
/* WindowsG.H header files!						     */

typedef struct InputWindowStruct {	  /* The internal window structures. */
    int WindowName;			   /* Name of window (unique index). */
    RealType MinX, MaxX, MinY, MaxY;	     /* Note they differ only in the */
    int FrameColor, LineColor, TextColor;	  /* last component - Lines. */
    int NumOfLines;
    RealType FirstLineX, FirstLineY, DiffYLine;
    char Lines[IW_NUM_OF_LINES][LINE_LEN];
} InputWindowStruct;

typedef struct StatusWindowStruct {	  /* The internal window structures. */
    int WindowName;			   /* Name of window (unique index). */
    RealType MinX, MaxX, MinY, MaxY;	     /* Note they differ only in the */
    int FrameColor, LineColor, TextColor;	  /* last component - Lines. */
    int NumOfLines;
    RealType FirstLineX, FirstLineY, DiffYLine;
    char Lines[SW_NUM_OF_LINES][LINE_LEN_SHORT];
} StatusWindowStruct;

typedef struct ViewWindowStruct {	  /* The internal window structures. */
    int WindowName;			   /* Name of window (unique index). */
    RealType MinX, MaxX, MinY, MaxY;	     /* Note they differ only in the */
    int FrameColor, LineColor, TextColor;	  /* last component - Lines. */
    int NumOfLines;
    RealType FirstLineX, FirstLineY, DiffYLine;
    char Lines[VW_NUM_OF_LINES][LINE_LEN];
} ViewWindowStruct;

#define	FRAME_X_WIDTH 0.03		      /* Width of the window frames. */
#define FRAME_Y_WIDTH 0.03

#define VIEW_WNDW_MAX_OBJ_NAMES	4	  /* Number of names in view window. */

/* The finally the prototypes of the local functions: */

void WndwDrawAllWndwFrames(void);

#endif	/* WINDOWS_LH */
