/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, Visible to others, definitions for the Input Parser module.	     *
*****************************************************************************/

#ifndef	INPT_PRSR_GH
#define	INPT_PRSR_GH

/*****************************************************************************
* The global (visible to others) function prototypes:			     *
*****************************************************************************/
int InputParser(void);
/* If the above returns NULL object the following might be called to find.   */
/* What went wrong (In the parsing stage, or in the evaluation stage.	     */
int InptPrsrParseError(char **Message);  /* Last error found in Parse stage. */
int InptPrsrEvalError(char **Message);    /* Last error found in evaluation. */

void FileInclude(char *FileName);  /* Used to insert files on include stack. */

void AliasReset(void);				/* Reset the aliases buffer. */

/*****************************************************************************
* Error	numbers	as located during the parsing process:			     *
*****************************************************************************/
#define IP_ERR_WrongSyntax	1
#define IP_ERR_ParamExpect	2
#define IP_ERR_OneOperand	3
#define IP_ERR_TwoOperand	4
#define IP_ERR_StackOV		5
#define IP_ERR_ParaMatch	6
#define IP_ERR_UndefToken	7
#define IP_ERR_UndefFunc	8
#define IP_ERR_NameTooLong	9
#define IP_ERR_ParamFunc	10
#define IP_ERR_NoParamFunc	11

/*****************************************************************************
* Error	as located during the evaluation process:			     *
*****************************************************************************/
#define	IE_ERR_FatalError	1
#define	IE_ERR_DivByZero	2
#define IE_ERR_NoObjMethod	3
#define IE_ERR_TypeMismatch	4
#define IE_ERR_AssignLeftOp	5
#define IE_ERR_MixedObj		6
#define IE_ERR_UndefObject	7
#define IE_ERR_NoAssignment	8
#define IE_ERR_FPError		9
#define IE_ERR_NumPrmMismatch	10
#define IE_ERR_MatPower		11
#define IE_ERR_FreeSimple	12
#define IE_ERR_ModifIterVar	13
#define IE_ERR_BooleanErr	14
#define IE_ERR_ListTooLong	15
#define IE_ERR_NonParamInList	16
#define IE_ERR_FreeNoRefObj	17
#define IE_ERR_DataPrsrError	18

#endif	/* INPT_PRSR_GH */
