/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General definitions of/for GeoMat3D.c module				     *
*****************************************************************************/

#ifndef	GEOMAT_3D_H
#define GEOMAT_3D_H

/* Used by the Ray & Polygon intersection (Jordan theorem): */
#define BELOW_RAY	1
#define ON_RAY		2
#define ABOVE_RAY	3

/* And prototypes of the functions: */

void MatGenUnitMat(MatrixType Mat);
void MatGenMatTrans(RealType Tx, RealType Ty, RealType Tz, MatrixType Mat);
void MatGenMatScale(RealType Sx, RealType Sy, RealType Sz, MatrixType Mat);
void MatGenMatRotX1(RealType Teta, MatrixType Mat);
void MatGenMatRotX(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void MatGenMatRotY1(RealType Teta, MatrixType Mat);
void MatGenMatRotY(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void MatGenMatRotZ1(RealType Teta, MatrixType Mat);
void MatGenMatRotZ(RealType CosTeta, RealType SinTeta, MatrixType Mat);

void MatMultTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatAddTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatSubTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);
void MatScale4by4(MatrixType MatRes, MatrixType Mat, RealType *Scale);

void MatMultVecby4by4(VectorType VRes, VectorType Vec, MatrixType Mat);

int MatInverseMatrix(MatrixType M, MatrixType InvM);

void VecCopy(VectorType Vdst, VectorType Vsrc);
void VecNormalize(VectorType V);
RealType VecLength(VectorType V);
void VecCrossProd(VectorType Vres, VectorType V1, VectorType V2);
RealType VecDotProd(VectorType V1, VectorType V2);

struct ObjectStruct *GenMatObjectRotX(RealType *Degree);
struct ObjectStruct *GenMatObjectRotY(RealType *Degree);
struct ObjectStruct *GenMatObjectRotZ(RealType *Degree);
struct ObjectStruct *GenMatObjectTrans(VectorType Vec);
struct ObjectStruct *GenMatObjectScale(VectorType Vec);
struct ObjectStruct *TransformObject(ObjectStruct *PObj, MatrixType Mat);

/* And the computational geometry routines: */
RealType CGDistPointPoint(PointType P1, PointType P2);
int CGPlaneFrom3Points(PlaneType Plane, PointType Pt1, PointType Pt2,
							PointType Pt3);
void CGPointFromPointLine(PointType Point, PointType Pl, PointType Vl,
						PointType ClosestPoint);
RealType CGDistPointLine(PointType Point, PointType Pl, PointType Vl);
RealType CGDistPointPlane(PointType Point, RealType Plane[4]);
int CGPointFromLinePlane(PointType Pl, PointType Vl, RealType Plane[4],
					PointType InterPoint, RealType *t);
int CGPointFromLinePlane01(PointType Pl, PointType Vl, RealType Plane[4],
					PointType InterPoint, RealType *t);
int CG2PointsFromLineLine(PointType Pl1, PointType Vl1,
			  PointType Pl2, PointType Vl2,
			  PointType Pt1, RealType *t1,
			  PointType Pt2, RealType *t2);
RealType CGDistLineLine(PointType Pl1, PointType Vl1,
			PointType Pl2, PointType Vl2);

int CGPolygonRayInter(PolygonStruct *Pl, PointType PtRay, int RayAxes);

#endif	/* GEOMAT_3D_H */
