/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions of DataPrsr goes to here:	     *
*****************************************************************************/

#ifndef	DATA_PRSR_LH
#define	DATA_PRSR_LH

#define UNGET_STACK_SIZE	5		     /* Internal stack size. */

/*****************************************************************************
* Tokens definitions goes into here					     *
*****************************************************************************/
#define	TKN_OPEN_PARAN	   1
#define	TKN_CLOSE_PARAN	   2

#define	TKN_NUMBER	   10	   /* Not used as number & names are decoded */
				   /* according to their places in grammer.  */

#define	TKN_VERTEX	   20
#define	TKN_POLYGON	   21
#define	TKN_POLYLINE	   22
#define	TKN_OBJECT	   23

#define	TKN_PLANE	   30
#define	TKN_INTERNAL	   31
#define	TKN_COLOR	   32

#define	TKN_OTHER	   100			/* Probably names & numbers. */
#define	TKN_EOF	   -1

/*****************************************************************************
* And some more	definitions ...						     *
*****************************************************************************/
typedef	struct BinTree {	   /* The entries are saved as binary trees. */
     char Name[OBJ_NAME_LEN];
     struct BinTree *Right, *Left;		      /* Classic, isnt it !? */
     union {
	  VoidPtr PVoid;		   /* Help to assign without type... */
	  struct VertexStruct	 *PVertex;
	  struct PolygonStruct	 *PPolygon;
     } U;
} BinTree;

/*****************************************************************************
* And finaly the prototypes of the local functions:			     *
*****************************************************************************/
static void DataPrsrPutMatObject(FILE *f, ObjectStruct *PObj);
static void DataPrsrPutGeomObject(FILE *f, ObjectStruct *PObj);
static ObjectStruct *DataPrsrGetGeomObject(FILE *f, char *ObjName);
static ObjectStruct *DataPrsrGetMatObject(FILE *f);
static void DPUpdatePolyPlane(PolygonStruct *PPoly);
static struct BinTree * AllocBinTree(char *Name,
				BinTree * Right, BinTree * Left, VoidPtr Ptr);
static void DataPrsrFreeAll(BinTree *VertexRoot, BinTree *PolygonRoot);
static void DataPrsrFreeTree(BinTree *Root, int ObjType);
static void UnGetToken(char *StringToken);
static void GetStringToken(FILE *f, char *StringToken);
static int GetToken(FILE *f, char *StringToken);
static void EliminateComments(FILE *f);
static void ParserError(int ErrNum, char *Msg);
static void InsertBinTree(BinTree **Tree, BinTree *PNewRecord);
static BinTree *GetBinTree(char *Name, BinTree *Tree);
static struct VertexStruct *GetVertexList(FILE *f,
				struct BinTree *VertexRoot, int PolyType);
static struct PolygonStruct *GetPolyList(FILE *f,
					struct BinTree *PolygonRoot);
static void GetPolyAttr(FILE *f, PolygonStruct *PPolygon, int *PlaneDefined);
static void GetVertexAttr(FILE *f, VertexStruct *PVertex);
static void GetObjectAttr(FILE *f, int *Color);

#endif	/* DATA_PRSR_LH */
