/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, local to module, definitions of View Object module.		     *
*****************************************************************************/

#ifndef	VIEW_OBJ_LH
#define	VIEW_OBJ_LH

/* Interactive menu setup structure: */
#define INTERACT_NUM_OF_STRINGS	3
#define INTERACT_NUM_OF_SUB_WINDOWS	9
#define INTERACT_SUB_WINDOW_HEIGHT	0.04  /* Actually half Height/Width. */
#define INTERACT_SUB_WINDOW_WIDTH	0.3

#define MAX_ROTATE_ANGLE	45.0 /* Maximum rates used by interact mode. */
#define MAX_TRANSLATE_FACTOR	2.0
#define MAX_SCALE_FACTOR	2.0

typedef struct InteractString {
    RealType X, Y;
    int Color;
    char *Str;
} InteractString;
typedef struct InteractSubWindow {
    RealType X, Y;					   /* Center points. */
    int Color,
	TextInside; /* If TRUE, Str will be in window, otherwise left to it. */
    char *Str;
} InteractSubWindow;
typedef struct InteractWindowStruct {	 /* The interactive menu structures. */
    /* Rotate, Translate, Scale strings:*/
    InteractString Strings[INTERACT_NUM_OF_STRINGS];
    InteractSubWindow SubWindows[INTERACT_NUM_OF_SUB_WINDOWS];
} InteractWindowStruct;

/* Prototypes for the View Object module: */
static int GetInternal(void);
static void ViewPolygon(PolygonStruct *Pl, int Color, int ShowNormals,
					MatrixType Mat, int ViewInternal);
static void InteractDrawMenu(void);
static void InteractHandleInput(ObjectStruct *PObj, MatrixType GlblViewMat);
static void ViewGeomObjectList(ObjectStruct *PObjList);
static void TestQuitView(void);

#endif	/* VIEW_OBJ_LH */
