/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, visible to others, definitions of primitiv module.		     *
*****************************************************************************/

#ifndef	PRIMITIV_GH
#define	PRIMITIV_GH

struct ObjectStruct * GenBOXObject(VectorType Pt, RealType *WidthX,
					RealType *WidthY, RealType *WidthZ);
struct ObjectStruct * GenGBOXObject(VectorType Pt,
			VectorType Dir1, VectorType Dir2, VectorType Dir3);
struct ObjectStruct * GenCONEObject(VectorType Pt, VectorType Dir, RealType *R);
struct ObjectStruct * GenCYLINObject(VectorType Pt, VectorType Dir, RealType *R);
struct ObjectStruct * GenSPHEREObject(VectorType Center, RealType *R);
struct ObjectStruct * GenTORUSObject(VectorType Center, VectorType Normal,
					RealType *Rmajor, RealType *Rminor);
struct ObjectStruct * GenPLANEObject(VectorType N, VectorType T, RealType *R);
struct ObjectStruct * GenPOLYObject(ObjectStruct *PObjList);
struct ObjectStruct * GenCROSSECObject(ObjectStruct *PObj);
struct ObjectStruct * GenSURFREVObject(ObjectStruct *Cross);
struct ObjectStruct * GenEXTRUDEObject(ObjectStruct *Cross, VectorType Dir);
void UpdatePolyPlane(PolygonStruct *PPoly, VectorType Vin);

#endif	/* PRIMITIV_GH */
