/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, visible to others, definitions of GraphGen module.		     *
*****************************************************************************/

#ifndef	GRAPH_GENERAL_GH				/* Define only once. */
#define	GRAPH_GENERAL_GH

enum WindowNameType {
    NO_WINDOW_NAME,
    INPUT_WINDOW_NAME,
    STATUS_WINDOW_NAME,
    VIEW_WINDOW_NAME
};

/* And finally the external routine prototypes: */

void GGMyMove(double x, double y);
void GGMyDraw(double x, double y);
void GGMySetColor(int color);
#ifdef __MSDOS__
void GGInitGraph(void);
#else
void GGInitGraph(int argc, char **argv);
#endif /* __MSDOS__ */
void GGCloseGraph(void);
void GGGetPoint(double *x, double *y);
void GGDrawPoint(double p[], char title[], int PointColor);
void GGWindowViewPort(double XMin, double YMin,
		      double XMax, double YMax, int WindowName);
void GGClearWindow(double XMin, double YMin,
		   double XMax, double YMax, int WindowName);
void GGClearAllScreen(void);
void GGXYPutChar(char c, int Color);
void GGXYPutStr(double x, double y, char *s);
void GGGetGraphicLine(double x, double y, char s[], int Length, int Color);
void GGTone(int Frequency, int Duration);

#endif /* GRAPH_GENERAL_GH */
