#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>

#include "rkipx.h"

void ShowInstructions( void );

int main( int argc, char *argv[] )
{
BYTE      Socket[2];
unsigned  rc, i;
long      len;
BYTE      *Buffer;

/* ==================================================== */
/* ==================================================== */

if ( argc < (3+1) )  // mode, filename, socket, optional len
  {
  ShowInstructions();
  return( -1 );
  }

if ( toupper( argv[1][0] ) == 'F' )
   {
   printf( "\nATTEMPTING FILE RECEIPT\n" );

   len = 0;
   rc = IPXReceiveRT( &len, argv[2], argv[3], NULL );
   if ( rc != GOOD_IPX_RETURN )
      {
      printf( "\n" );
      printf( "FUNCTION ERROR: %02X\n", rc );
      printf( "  IPXAPI ERROR: %02X\n\n", IPXerrno );
      return( -1 );
      }

   printf( "\nSUCCESSFUL FILE RECEIPT\n" );

   }

if ( toupper( argv[1][0] ) == 'B' && argc == 5 )
   {
   printf( "\nATTEMPTING BUFFER RECEIPT\n" );

   len = atol( argv[4] );
   Buffer = farcalloc( 1, len+1 );
   if ( !Buffer )
      {
      printf( "\nPROBLEM WITH MEMORY ALLOCATION\n" );
      return( -1 );
      }

   rc = IPXReceiveRT( &len, Buffer, argv[3], NULL );
   if ( rc != GOOD_IPX_RETURN )
      {
      printf( "\n" );
      printf( "FUNCTION ERROR: %02X\n", rc );
      printf( "  IPXAPI ERROR: %02X\n\n", IPXerrno );
      farfree( Buffer );
      return( -1 );
      }

   printf( "\nSUCCESSFUL BUFFER RECEIPT: %ld bytes\n", len );
   Buffer[len] = '\0';
   printf( "%s", Buffer );
   farfree( Buffer );
}

return( 0 );
}

/*******************************************************************/
/*******************************************************************/
void ShowInstructions( void )
{
printf( "\n\n\n" );
printf( "ͻ\n" );
printf( " IPX File Receive Utility version 1.2  RK  6 Jun 92 \n" );
printf( "   (c) 1992 by R. Kvinnesland                       \n" );
printf( "                                                    \n" );
printf( " USE:  IPXFRX p1 p2 p3 p4                           \n" );
printf( "       where p1 = 'B'(uffer) or 'F'(ile)            \n" );
printf( "             p2 = name of file                      \n" );
printf( "             p3 = socket (4 hex digits)             \n" );
printf( "             p4 = size of buffer                    \n" );
printf( "                                                    \n" );
printf( " EXAMPLE:                                           \n" );
printf( "                                                    \n" );
printf( " IPXFRX f myfile.dat 0420 <ENT>                     \n" );
printf( " IPXFRX b xxxxxx.xxx 0420 2000<ENT>                 \n" );
printf( "                                                    \n" );
printf( "ͼ\n" );
printf( "\n\n\n\n\n\n\n" );
return;
}

/* ======================================================================= */
/* EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF EOF */
/* ======================================================================= */
