/****************************************************************************/
/*																																					*/
/* T.H                                                                      */
/*																																					*/
/*																																					*/
/****************************************************************************/
#include "uw.h"
#include "uw_globx.h"
#include "uw_keys.h"

/*---------------------------- dialog defines ------------------------------*/
#define		ADD_FAIL				-1
#define		ADD_TO_END			-1
#define		DEFINE_LEN			21

#define		T_DIALOG				0x01									/* The main dlg parent			*/
#define		T_BOX						0x02									/* sub-boxes within the dlg	*/
#define		T_BUTTON				0x03									/* the button								*/
#define		T_CHECK					0x04									/* the checkable type				*/
#define		T_INPUT					0x05									/* string input type				*/
#define		T_SLIDER				0x06									/* slider track and box			*/
#define		T_ICON					0x07									/* icon with two images			*/

#define		F_SELECTABLE		0x0001								/* flag values							*/
#define		F_TABABLE				0x0002
#define		F_RADIO					0x0004

#define		F_EXIT_PRESS		0x0008
#define		F_EXIT_RELEASE	0x0010
#define		F_EXIT_OVER			0x0020
#define		F_IS_EXIT				0x0038

#define		F_SELECTED			0x0040
#define		F_TABBED				0x0080
#define		F_DESEL_RADIO		0x0100
#define		F_EXIT_ALL			0x0200

#define		S_NORMAL				0x00									/* various styles						*/
#define		S_SHADOWED			0x01

#define		SLIDER_LEFT			0											/* slider char index values	*/
#define		SLIDER_RIGHT		1
#define		SLIDER_TOP			2
#define		SLIDER_BOTTOM		3
#define		SLIDER_TRACK		4
#define		SLIDER_BOX			5

#define		DO_NORMAL				0x0001								/* normal dialog processing	*/
#define		DO_RETURN_EVENT	0x0002								/* return unknown events		*/

#define		DO_RETURN_TAB		0x0004								/* command key defines			*/
#define		DO_RETURN_ENTER	0x0008
#define		DO_RETURN_LEFT	0x0010
#define		DO_RETURN_RIGHT	0x0020
#define		DO_RETURN_UP		0x0040
#define		DO_RETURN_DOWN	0x0080

#define		DO_RETURN_ARROW	0x00F0								/* return dialog arrow keys	*/
#define		DO_RETURN_CMD		0x00FC								/* return dialog cmd keys		*/

#define		DO_INPUT_ADV		0x0100								/* advance tab on input   	*/

#define		NO_SELECTION		-1										/* just esc from do_dialog	*/
#define		EVENT_RETURNED	-2										/* unprocessed event				*/

#define		FNAME_LEN       41										/* TUI help defines					*/
#define		MATCH_LEN       41

/*------------------------ TUI dialog object structres ---------------------*/
typedef union ptr_union_struct									/* structure for compatible	*/
{																								/* pointer sizes between		*/
	uchar		data[4];                              /* large and small models!	*/
	uchar		*ptr;
} PTR_UNION;

typedef struct tui_base_struct
{																								/* common pieces						*/
	uint			flags;															/* 16 bits for flags 				*/
	uchar			type;																/* the type of TUI object		*/
	uchar			x_off;															/* x offset from parent			*/
	uchar			y_off;															/* x offset from parent			*/
	uchar			width;                            	/* width in cells           */
	uchar			height;                           	/* height in cells          */
	uchar			p_att;															/* primary attribute 				*/
	uchar			s_att;															/* secondary attribute 			*/
	uchar			style;															/* the style - shadow, norm	*/
	int				parent;															/* index of the parent			*/
	PTR_UNION	more;																/* pointer to more params		*/
	int				hot_key;														/* hot key to select item		*/
	int				transfer;														/* dialog transfer index		*/
	uchar			expansion[12];											/* for later expansion			*/
} TUI_BASE;

typedef struct tui_button_struct
{
	uchar			norm_att;														/* normal attribute 				*/
	uchar			norm_f_att;													/* normal first attribute		*/
	uchar			sel_att;														/* selected attribute				*/
	uchar			sel_f_att;													/* selected first attribute	*/
	uchar			tab_color;													/* tabbed text color!				*/
	uchar			first_pos;													/* first letter position		*/
	int				len;																/* button text length				*/
	PTR_UNION	text;                               /* the button text  				*/
	uchar			expansion[4];												/* for later expansion			*/
} TUI_BUTTON;

typedef struct tui_check_struct
{
	uchar			norm_att;														/* normal attribute 				*/
	uchar			tab_color;													/* tabbed text color!				*/
	uchar			mark_pos;														/* position for mark char		*/
	uchar			mark_char;													/* mark character itself		*/
	int				len;																/* check text length				*/
	PTR_UNION	text;                               /* the check text itself		*/
	uchar			norm_f_att;													/* normal first attribute		*/
	uchar			first_pos;													/* first letter position		*/
	uchar			expansion[2];												/* for later expansion			*/
} TUI_CHECK;

typedef struct tui_input
{
	uchar			norm_att;														/* normal attribute 				*/
	uchar			tab_color;													/* tabbed text color				*/
	int				len;																/* input length							*/
	PTR_UNION	text;																/* the edited string				*/
	PTR_UNION	mask;																/* the mask for display			*/
	PTR_UNION	template;														/* validation characters		*/
	uchar     input_flags;												/* strip mode, char display	*/
	uchar			expansion[3];												/* for later expansion			*/
} TUI_INPUT;

typedef struct tui_slider
{
	uchar		arrow_att;														/* attribute for arrow			*/
	uchar		track_att;														/* attribute for track			*/
	uchar		grab_att;															/* attribute for grabber    */
	uchar		slider_chars[6];											/* the chars for the slider	*/
	long    position;															/* runs from 0..(total-1)  	*/
	long		page_amt;															/* amt to page up/down 			*/
	long		total;																/* total represented				*/
	uchar		expansion[4];													/* for later expansion			*/
} TUI_SLIDER;

typedef struct tui_icon_struct
{
	uchar			norm_att;														/* normal attribute 				*/
	uchar			sel_att;														/* selected attribute				*/
	uchar			tab_color;													/* tabbed color!						*/
	PTR_UNION	images;                             /* ptr to w x h images			*/
	uchar			expansion[4];												/* for later expansion			*/
} TUI_ICON;

typedef struct tui_struct												/* the actual TUI structure	*/
{
	int				num_base;														/* number of base items			*/
	long			version_num;												/* tui version number				*/
	uchar			font_0_used;												/* is the first font used?	*/
	char			font_0_name[13];										/* filename for font 0			*/
	uchar			font_1_used;												/* is the second font used?	*/
	char			font_1_name[13];										/* filename for font 1			*/
	uchar			blink_set;													/* is blink enable set?			*/
	uchar			manager_used;												/* do we use the manager?		*/
	uchar			rows;																/* number of rows for video	*/
	uchar			back_att;														/* main back window color		*/
	uchar			back_bdr_att;												/* main back border color		*/
	uchar			palette[16];												/* the color palette				*/
	uchar			expansion[457];											/* for later expansion			*/

	WINDOW		*back_wnp;													/* back screen window ptr		*/
	TUI_BASE	*base;
} TUI;

/*---------------------------- TUI help structres --------------------------*/
typedef struct tui_keyword
{
	int    line;																	/* keyword line             */
	int    col;                                 	/* keyword column           */
	int    dos_cmd;																/* 1 if extra is dos cmd 		*/
	char   *search;		                          	/* str associated with kwd	*/
	char   *keyword;															/* the keyword itself       */
	char 	 *fname;																/* filename if not in file	*/
	struct tui_keyword *prev;                			/* pointer to prev keyword	*/
	struct tui_keyword *next;                			/* pointer to next keyword  */
} TUI_KEYWORD;

typedef struct help_struct
{
	uchar    		keyword_att;
	uchar    		hilite_att;
	uchar    		default_att;
	uchar    		first_char_att;
	int      		num_lines;
	char     		**lines;
	char     		*line_atts;
	TUI_KEYWORD	*keyword_list, *keyword_end;
	int      		num_keywords;
	int      		tab_size;
	int      		first_col, curr_col;
	int      		top_line, curr_line;
	int      		chain_flag;
	WINDOW   		*wnp;
	char     		fname[FNAME_LEN];
	char     		match[MATCH_LEN];
} TUI_HELP;

/*------------------------ time/date/directory defines ---------------------*/

typedef struct  file_blk
{														/* provide common def for Borland and Microsoft */
    char        reserved[21];
    char        attrib;
    unsigned    ftime;
    unsigned    fdate;
    long        fsize;
    char        name[13];
} FBLK;

typedef struct ft_struct
{
	unsigned seconds	: 5;
	unsigned minutes	: 6;
	unsigned hours		: 5;
} FILE_TIME;

typedef struct fd_struct
{
	unsigned days			: 5;
	unsigned months 	: 4;
	unsigned years		: 7;
} FILE_DATE;

typedef struct dir_struct
{
	char				f_attrib;
	FILE_TIME		f_time;
	FILE_DATE		f_date;
	long				f_size;
	char				f_name[9];
	char				f_ext[4];
} DIR;

/*------------------------------ get macros --------------------------------*/
#define get_dlg_wnp(tp, i)	 	(WINDOW *) tp->base[i].more.ptr
#define	get_item_type(tp, i)	tp->base[i].type
#define	get_item_x(tp, i)		 	tp->base[i].x_off
#define	get_item_y(tp, i)		 	tp->base[i].y_off
#define	get_item_w(tp, i)		 	tp->base[i].width
#define	get_item_h(tp, i)			tp->base[i].height

#define	get_box_att(tp, i)	 	tp->base[i].p_att

#define	get_sldr_pos(tp, i)	 	((TUI_SLIDER *)(tp->base[i].more.ptr))->position

#define	get_str_text(tp, i)	 	((TUI_BUTTON *)(tp->base[i].more.ptr))->text.ptr

#define	get_btn_text(tp, i)	 	((TUI_BUTTON *)(tp->base[i].more.ptr))->text.ptr
#define	get_btn_att(tp, i)	 	((TUI_BUTTON *)(tp->base[i].more.ptr))->norm_att

#define	get_check_text(tp, i)	((TUI_CHECK *)(tp->base[i].more.ptr))->text.ptr

#define	get_inp_text(tp, i)		((TUI_INPUT *)(tp->base[i].more.ptr))->text.ptr
#define	get_inp_mask(tp, i)		((TUI_INPUT *)(tp->base[i].more.ptr))->mask.ptr
#define	get_inp_tplt(tp, i)		((TUI_INPUT *)(tp->base[i].more.ptr))->template.ptr

/*------------------------------ set macros --------------------------------*/
#define set_btn_text(tp,i,s)	set_base_btn_text(&tp->base[i], s)
#define set_str_text(tp,i,s)	set_base_btn_text(&tp->base[i], s)
#define set_inp_strs(tp,i,t,m,p)	set_base_input_strs(&tp->base[i], t, m, p)

/*----------------------------- other macros -------------------------------*/
#define	is_valid_inx(tp, i)	 	range(1, i, (tp->num_base - 1))
#define	is_selected(tp, i)   	(tp->base[i].flags & F_SELECTED)
#define	is_tabbed(tp, i)     	(tp->base[i].flags & F_TABBED)

#define	select(tp, i)				 	tp->base[i].flags |= F_SELECTED
#define	deselect(tp, i)			 	tp->base[i].flags &= ~F_SELECTED
#define	tab(tp, i)				 	 	tp->base[i].flags |= F_TABBED
#define	detab(tp, i)			 	 	tp->base[i].flags &= ~F_TABBED

#include "t_proto.h"
/*** END OF FILE ***/
