/****************************************************************************/
/*																																					*/
/* INSTALL.C                                                                */
/*																																					*/
/*																																					*/
/****************************************************************************/
/*----------------------------- include files ------------------------------*/
#include <stdio.h>
#include <alloc.h>
#include <ctype.h>
#include "t.h"																/* include the TUI header			*/
#include "install.def"											/* include dialog definitions	*/

void register_install_tui( TUI *tuip );

/*--------------------------------- globals --------------------------------*/
WINDOW	*Out_wnp;

TUI			Install_tui, *Tuip = &Install_tui;

char Src_install;
char Hdr_install;
char Lib_install;
char Help_install;
char Src = 'A', Dest = 'C';
char *Compiler = "borlandc";
int  X_off, Y_off, Width, Uwin_flag, Tui_flag;

/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
main( int argc, char *argv[] )
{
	int  i, scan_lines;
	char *p, *ps, fname[81];

	if( argc && (argv[0][1] == ':') )					/* run from a different drive?	*/
		Src = argv[0][0];

	register_install_tui(Tuip);
	init_tui(Tuip);
	select(Tuip, DEST_C);
	select(Tuip, BORLAND);
	select(Tuip, SRC_INSTALL);
	select(Tuip, HDR_INSTALL);
	select(Tuip, LIB_INSTALL);
	select(Tuip, HELP_INSTALL);
	Src_install = Hdr_install = Lib_install = Help_install = 1;
	sprintf(fname, "%c:uwinv201.ver",Src);
	set_str_text(Tuip,NAME,"UltraWin Installation");
	strcpy( get_inp_text(Tuip,SRC_PATH),  "c:\\borlandc\\uwin"  );
	strcpy(   get_inp_text(Tuip,HDR_PATH),  "c:\\borlandc\\include" );
	strcpy(   get_inp_text(Tuip,LIB_PATH),  "c:\\borlandc\\lib"     );
	strcpy(   get_inp_text(Tuip,HELP_PATH), "c:\\borlandc\\enqhelp" );
	X_off = get_item_x(Tuip, VIEW_BOX);
	Y_off = get_item_y(Tuip, VIEW_BOX);
	Width = get_item_w(Tuip, VIEW_BOX);

	for( i = 0; i < 2; i++ )
	{
		if( i != 0 )
		{
			set_str_text(Tuip,NAME,"InTUItion Installation");
			ps = p = get_inp_text(Tuip,SRC_PATH);
			while( *p ) p++;
			while( p > ps )
			{
				if( *p-- == '\\' )
				{
					p += 2;
					break;
				}
			}
			strcpy( p,  "tui" );
		}
		interact1(Tuip, INSTALL_DLG);

		if( i == 0 )
			Tui_flag = interact2(Tuip, INSTALL_DLG2);

		if( !Tui_flag || (i == 1) )
			break;
	}
	end_tui(Tuip);
	free_tui(Tuip);
	exit(0);
}
/*** end of main ***/

/*************/
/* ~interact */
/*           ****************************************************************/
/* Shell code for typical dialog interaction.  A pointer to the TUI and the */
/* define for the dialog are passed.                                        */
/*                                                                          */
/* Pass the DO_NORMAL define to do_dialog if you do not want to have every  */
/* event the do_dialog function does not understand returned to you!        */
/****************************************************************************/
interact1( TUI *tuip, int dlg_inx )
{
	int inx, end_flag = OFF;
	int old_dest = Dest;

	draw_dialog(tuip, dlg_inx);
	Out_wnp = get_dlg_wnp(Tuip, INSTALL_DLG);
	while (!end_flag)
	{
		Event.key = 0;
		inx = do_dialog(tuip, dlg_inx, DO_RETURN_EVENT);
		if( (Event.m_button == RB) ||
			 ((Event.key == KEY_ALT_H) && (inx == EVENT_RETURNED)) )
			install_help();
		else switch( inx )
		{
			/*---------------- ESC pressed or clicked off dialog -----------------*/
			case NO_SELECTION:
				end_flag = ON;
				break;

			case CANCEL:
				deselect(tuip, inx);
				detab(tuip, inx);
				draw_item(tuip, inx);
				end_flag = 2;
				break;

			case OK:
				deselect(tuip, inx);
				detab(tuip, inx);
				draw_item(tuip, inx);
				end_flag = 1;
				break;

			case SRC_INSTALL:
				Src_install = is_selected(Tuip,inx);
				break;
			case HDR_INSTALL:
				Hdr_install = is_selected(Tuip,inx);
				break;
			case LIB_INSTALL:
				Lib_install = is_selected(Tuip,inx);
				break;
			case HELP_INSTALL:
				Help_install = is_selected(Tuip,inx);
				break;

			case MICROSOFT:
				Compiler = "msc";
				change_compiler(tuip);
				break;
			case BORLAND:
				Compiler = "borlandc";
				change_compiler(tuip);
				break;
			case TURBO:
				Compiler = "tc";
				change_compiler(tuip);
				break;

			case DEST_C: Dest = 'c';	break;
			case DEST_D: Dest = 'd';	break;
			case DEST_E: Dest = 'e';	break;
			case DEST_F: Dest = 'f';	break;
		}
		if( Dest != old_dest )													/* change path names	*/
		{
			old_dest = Dest;
			change_dest(tuip);
		}
	}
	if( end_flag == 1 )
		install(tuip);
	erase_dialog(tuip, dlg_inx);
}
/*** end of interact ***/


/*************/
/* ~interact */
/*           ****************************************************************/
/* Shell code for typical dialog interaction.  A pointer to the TUI and the */
/* define for the dialog are passed.                                        */
/*                                                                          */
/* Pass the DO_NORMAL define to do_dialog if you do not want to have every  */
/* event the do_dialog function does not understand returned to you!        */
/****************************************************************************/
interact2( TUI *tuip, int dlg_inx )
{
	int ret_inx, stat = 0, end_flag = OFF;

	center_dialog(tuip,dlg_inx);
	draw_dialog(tuip, dlg_inx);
	while (!end_flag)
	{
		ret_inx = do_dialog(tuip, dlg_inx, DO_RETURN_EVENT);
		switch( ret_inx )
		{
			case OK2:
				stat = 1, end_flag = 1;
				break;
			case CANCEL2:
				end_flag = 1;
				break;
		}
	}
	erase_dialog(tuip, dlg_inx);
	return(stat);
}
/*** end of interact ***/


change_dest( TUI *tuip )
{
	int i, inxs[] = { SRC_PATH, HDR_PATH, LIB_PATH, HELP_PATH };
	char *p;

	for( i = 0; i < 4; i++ )
	{
		p = get_inp_text(Tuip,inxs[i]);
		*p = Dest;
		draw_item( tuip, inxs[i] );
	}
}

change_compiler( TUI *tuip )
{
	int i, x, inxs[] = { SRC_PATH, HDR_PATH, LIB_PATH, HELP_PATH };
	char buff[133], *p, *p1;

	for( i = 0; i < 4; i++ )
	{
		setmem(buff, 132, 0);
		p = get_inp_text(Tuip,inxs[i]);

		if( p[1] == ':' && p[2] == '\\' )
			strncpy( buff, p, 3 );
		else if( p[1] == ':' )
			strncpy( buff, p, 2 );
		strcat( buff, Compiler );

		if( strchr(p,'\\') != NULL )
			strcat( buff, strchr(strchr(p,'\\') + 1, '\\') );

		strcpy( p, buff );
		draw_item( tuip, inxs[i] );
	}
}

install()
{
	int r = 0;
	char buff[133], buff1[133];
	Out_wnp->att = (LIGHTGRAY << 4) | RED;

	if( Src_install )
	{
		mymkdir( get_inp_text(Tuip,SRC_PATH) );
		sprintf(buff, "%c:pkunzip -o %c:source.zip %s > nul", Src, Src, get_inp_text(Tuip,SRC_PATH) );
		if( check_for_file("source.zip") )
		{
			strcpy(buff1,buff),	buff1[strlen(buff)-6] = '\0',	buff1[Width] = '\0';
			wn_plst( X_off, Y_off + r++, buff1, Out_wnp );
			system(buff);
		}
	}
	if( Hdr_install )
	{
		mymkdir( get_inp_text(Tuip,HDR_PATH) );
		sprintf(buff, "%c:pkunzip -o %c:hdr.zip %s > nul", Src, Src, get_inp_text(Tuip,HDR_PATH) );
		if( check_for_file("hdr.zip") )
		{
			strcpy(buff1,buff),	buff1[strlen(buff)-6] = '\0',	buff1[Width] = '\0';
			wn_plst( X_off, Y_off + r++, buff1, Out_wnp );
			system(buff);
		}
	}
	if( Lib_install )
	{
		mymkdir( get_inp_text(Tuip,LIB_PATH) );
		sprintf(buff, "%c:pkunzip -o %c:lib.zip %s > nul", Src, Src, get_inp_text(Tuip,LIB_PATH) );
		if( check_for_file("lib.zip") )
		{
			strcpy(buff1,buff),	buff1[strlen(buff)-6] = '\0',	buff1[Width] = '\0';
			wn_plst( X_off, Y_off + r++, buff1, Out_wnp );
			system(buff);
		}
	}
	if( Help_install )
	{
		mymkdir( get_inp_text(Tuip,HELP_PATH) );
		sprintf(buff, "%c:pkunzip -o %c:help.zip %s > nul", Src, Src, get_inp_text(Tuip,HELP_PATH) );
		if( check_for_file("help.zip") )
		{
			strcpy(buff1,buff),	buff1[strlen(buff)-6] = '\0',	buff1[Width] = '\0';
			wn_plst( X_off, Y_off + r++, buff1, Out_wnp );
			system(buff);
		}
	}
}

mymkdir( char *p )
{
	int i;
	char tmp[81], tmp1[81];

	i = 0;
	tmp[i++] = *p++;
	tmp[i++] = *p++;
	tmp[i++] = *p++;
	while( *p )
	{
		while( *p && (*p != '\\') )
			tmp[i++] = *p++;
		tmp[i] = '\0';
		mkdir(tmp);
		if( *p == '\\' )
			tmp[i++] = *p++;
	}
}

check_for_file( char *s )
{
	char fname[81];

	sprintf(fname, "%c:%s", Src, s);
	return( !access(fname,0) );
}

char *Helps[] = {
"/// Setting install check boxes",
"  There is a check box next to each path.  Click on the check box or",
"  press the indicated key to turn the check box on/off.  Only those",
"  boxes with an X will be installed.",
"",
"/// Setting up directory paths",
"  There are four directory paths that need to be created. Default paths",
"  are created for Borland C.  You can change each path individually by",
"  clicking on the path string or pressing 1-5.  If you elect to use the",
"  standard directories, borlandc, tc, or msc, simply click or select the",
"  desired compiler.",
"",
"/// Setting the destination drive",
"  Clicking or selecting (Alt C-E) a destination drive will automatically",
"  change the paths for you.  You can also change them individually.",
"END"
};

install_help()
{
	int i;
	WINDOW wn;

	m_hide();
	wn_create( 2, 2, V_cols-4, V_rows-4, SGL_BDR, WN_POPUP, &wn );
	wn_color( LIGHTGRAY, RED, &wn );
	wn_name("Help", &wn);
	wn_set(&wn);
	for( i = 0; i < 20 && strcmp(Helps[i],"END") ; i++ )
		wn_plst( 1, i + 1, Helps[i], &wn );
	wait_event();
	wn_destroy(&wn);
	m_show();
}

/*------------------- slider/image/palette globals -------------------------*/
uchar Palette_ins_tui[16] =
	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F };

/*************************/
/* ~register_install_tui */
/*                       ****************************************************/
/* Call this function to register the TUI.  This replaces load_tui!         */
/****************************************************************************/
void register_install_tui( TUI *tuip )
{
  setmem(tuip, sizeof(TUI), 0);
  add_dialog(tuip, 0x0000, 0, 1, 80, 23, 0x17, 0x1E, 2);
  add_button(tuip, 0, 0x0000, 0, 27, 0, 23, 1, 0,
    0x1E, 0x1e, 0x1e, 0x1e, 0x1e, 0, "");
  add_box(tuip, 0, 0x0011, 0, 2, 12, 53, 7, 0x71, 1);
  add_box(tuip, 0, 0x0000, 0, 60, 12, 14, 7, 0x3F, 1);
  add_button(tuip, 0, 0x0000, 0, 62, 12, 11, 1, 0,
		0x34, 0x34, 0x34, 0x34, 0x34, 0, "Compiler");
  add_box(tuip, 0, 0x0000, 0, 60, 2, 14, 9, 0x3F, 1);
  add_button(tuip, 0, 0x0000, 0, 60, 2, 14, 1, 0,
    0x34, 0x34, 0x34, 0x34, 0x34, 0, "Dest (Alt C-F)");
  add_box(tuip, 0, 0x0000, 0, 2, 2, 53, 9, 0x4F, 1);
  add_button(tuip, 0, 0x0000, 0, 21, 7, 2, 1, 1,
    0x1E, 0x1e, 0x1e, 0x1e, 0x1e, 0, "3)");
  add_button(tuip, 0, 0x0000, 0, 21, 5, 2, 1, 1,
    0x1E, 0x1e, 0x1e, 0x1e, 0x1e, 0, "2)");
  add_button(tuip, 0, 0x0000, 0, 21, 3, 2, 1, 1,
    0x1E, 0x1e, 0x1e, 0x1e, 0x1e, 0, "1)");
  add_button(tuip, 0, 0x0000, 0, 21, 9, 2, 1, 1,
    0x1E, 0x1e, 0x1e, 0x1e, 0x1e, 0, "4)");
  add_button(tuip, 0, 0x0000, 0, 29, 2, 13, 1, 0,
    0x4E, 0x4e, 0x4e, 0x4e, 0x4e, 0, "Install Paths");
  add_button(tuip, 0, 0x0000, 0, 5, 2, 14, 1, 0,
    0x4E, 0x4e, 0x4e, 0x4e, 0x4e, 0, "Install ON/OFF");
  add_check(tuip, 83, 0x0013, 0, 4, 3, 13, 1, 0,
    0x47, 0x4E, 0x1f, 1, 0x58, 4, "[ ] Source");
  add_input(tuip, 49, 0x000B, 0, 23, 3, 23, 1, 1, 0x1e, 0x0f, 0x02,
    "",
		"________________________________________________________________________________",
    "********************************************************************************");
  add_check(tuip, 72, 0x0013, 0, 5, 5, 12, 1, 0,
    0x47, 0x4E, 0x1f, 1, 0x58, 4, "[ ] Headers");
  add_input(tuip, 50, 0x000B, 0, 23, 5, 23, 1, 1, 0x1e, 0x0f, 0x02,
    "",
    "________________________________________________________________________________",
		"********************************************************************************");
  add_check(tuip, 76, 0x0013, 0, 5, 7, 13, 1, 0,
    0x47, 0x4E, 0x1f, 1, 0x58, 4, "[ ] Libraries");
  add_input(tuip, 51, 0x000B, 0, 23, 7, 23, 1, 1, 0x1e, 0x0f, 0x02,
    "",
    "________________________________________________________________________________",
    "********************************************************************************");
  add_check(tuip, 69, 0x0013, 0, 5, 9, 9, 1, 0,
    0x47, 0x4E, 0x1f, 1, 0x58, 5, "[ ] Help");
  add_input(tuip, 52, 0x000B, 0, 23, 9, 23, 1, 1, 0x1e, 0x0f, 0x02,
		"",
    "________________________________________________________________________________",
    "********************************************************************************");
  add_button(tuip, 302, 0x0017, 0, 64, 3, 5, 1, 1,
    0x1B, 0x1e, 0x03, 0x0e, 0x0f, 0, "C");
  add_button(tuip, 288, 0x0017, 0, 64, 5, 5, 1, 1,
    0x1B, 0x1e, 0x03, 0x0e, 0x0f, 0, "D");
	add_button(tuip, 274, 0x0017, 0, 64, 7, 5, 1, 1,
    0x1B, 0x1e, 0x03, 0x0e, 0x0f, 0, "E");
  add_button(tuip, 289, 0x0017, 0, 64, 9, 5, 1, 1,
    0x1B, 0x1e, 0x03, 0x0e, 0x0f, 0, "F");
  add_button(tuip, 66, 0x0017, 0, 61, 13, 11, 1, 1,
    0x17, 0x1e, 0x03, 0x0e, 0x0f, 0, "Borland");
  add_button(tuip, 84, 0x0017, 0, 61, 15, 11, 1, 1,
    0x17, 0x1e, 0x03, 0x0e, 0x0f, 0, "Turbo");
  add_button(tuip, 77, 0x0017, 0, 61, 17, 11, 1, 1,
    0x17, 0x1e, 0x03, 0x0e, 0x0f, 0, "Microsoft");
  add_button(tuip, 67, 0x0013, 0, 2, 20, 8, 1, 1,
    0x71, 0x74, 0x03, 0x0e, 0x0f, 0, "Cancel");
  add_button(tuip, 75, 0x0013, 0, 69, 20, 8, 1, 1,
    0x71, 0x74, 0x03, 0x0e, 0x0f, 1, "Ok");
	add_dialog(tuip, 0x0000, 20, 5, 40, 7, 0x4E, 0x4E, 1);
  add_button(tuip, 67, 0x0013, 0, 3, 4, 12, 1, 1,
    0x1B, 0x1e, 0x03, 0x0e, 0x0f, 0, "Cancel");
	add_button(tuip, 75, 0x0013, 0, 24, 4, 12, 1, 1,
		0x1B, 0x1e, 0x03, 0x0e, 0x0f, 1, "Ok");
	add_button(tuip, 0, 0x0000, 0, 3, 1, 33, 1, 0,
    0x4F, 0x4f, 0x4f, 0x4f, 0x4f, 0, "If you wish to install InTUItion,");
	add_button(tuip, 0, 0x0000, 0, 3, 2, 33, 1, 0,
		0x4F, 0x4f, 0x4f, 0x4f, 0x4f, 0, "insert disk and press Ok");
	set_tui_parenting(tuip);
	tuip->version_num = 100L;
	tuip->blink_set = ON;
	tuip->rows = 25;
	tuip->back_att = 0x03;
	tuip->back_bdr_att = 0x03;
	movmem(Palette_ins_tui, tuip->palette, 16);
}
/*** end of register_install_tui ***/

compatibility_hook(){}
init_uw_graphics(){}
g_ch(){}

/**** END OF FILE ****/
