/****************************************************************************/
/* Prototype File                                Fri Oct 04 21:59:43 1991   */
/****************************************************************************/

/*------------------------- Prototypes for T_BASE.C ------------------------*/
base_at_cr( TUI *tuip, int inx, int col, int row);
void free_base( TUI *tuip, int inx );
void realloc_base( TUI *tuip, int n_alloc );
add_base( TUI *tuip, int inx );
del_base( TUI *tuip, int inx );
free_tui( TUI *tuip );

/*------------------------- Prototypes for T_DLG.C  ------------------------*/
void clear_area( WINDOW *wnp, int x, int y, int width, int height );
void draw_shadow( WINDOW *wnp, TUI_BASE *basep );
void draw_box( WINDOW *wnp, TUI_BASE *basep );
void draw_square_text( WINDOW *wnp, TUI_BASE *basep, int len, uchar *text );
void draw_button( WINDOW *wnp, TUI_BASE *basep );
void draw_check( WINDOW *wnp, TUI_BASE *basep );
void draw_input( WINDOW *wnp, TUI_BASE *basep );
void draw_slider( WINDOW *wnp, TUI_BASE *basep );
void draw_icon( WINDOW *wnp, TUI_BASE *basep );
void draw_base( WINDOW *wnp, TUI_BASE *basep );
draw_item( TUI *tuip, int inx );
void refresh_base( WINDOW *wnp, TUI_BASE *basep );
void refresh_dialog( TUI *tuip, int inx );
draw_dialog( TUI *tuip, int inx );
erase_dialog( TUI *tuip, int inx );
void center_dialog( TUI *tuip, int inx );
void position_dialog( TUI *tuip, int inx, int col, int row );
void desel_radios( WINDOW *wnp, TUI_BASE *cmpp, TUI_BASE *basep, int cnt );
process_input( WINDOW *wnp, TUI_BASE *basep, int mode, int *proc_mouse, int *proc_key );
void validate_slider( TUI_SLIDER *sldrp );
process_slider( WINDOW *wnp, TUI_BASE *basep );
process_btnchk( TUI_BASE *basep, WINDOW *wnp, TUI_BASE *dlgp, int num_in_dlg);
void wait_for_release();
advance_tabs(TUI *tuip, int inx, WINDOW *wnp, int num_in_dlg, int num_with_tab,
						 int key, int *tab_inx);
do_dialog( TUI *tuip, int inx, int mode );

/*------------------------- Prototypes for T_FSEL.C ------------------------*/
getdisk();
setdisk(int drive);
long datetol( FILE_DATE *date );
void get_curr_path( char *path );
remove_lastdir(char *d);
int cmp_dir_name( const void *p1, const void *p2 );
int cmp_dir_ext( const void *p1, const void *p2 );
int cmp_dir_size( const void *p1, const void *p2 );
int cmp_dir_datetime( const void *p1, const void *p2 );
void sort_directory(DIR *dir_array, int num, int sort_type);
void split_fn_ext( char *n, char *f, char *s);
void merge_fn_ext( char *n, char *f, char *s);
directory_read(char *path, char *wildcard, DIR *dir_array, int *num );
void make_path_plus( char *dest, char *path, char *name );
void split_path( char *path_plus, char *path, char *wildcard );
void make_filesel_strs( int num, DIR *dir_array, char *str_buffer );
file_selected( char *wildcard, char *path, char *filename, char *fullname );
void validate_offset( int csr, int h, int *offset );
ffirst( char *p, FBLK *fblk, int mode );
fnext( FBLK *fblk );

/*------------------------- Prototypes for T_UTIL.C ------------------------*/
void set_slider( TUI *tuip, int inx, long position, long page_amt, long total );
void set_base_btn_text( TUI_BASE *basep, char *new_text );
void set_base_check_text( TUI_BASE *basep, char *new_text );
void set_base_input_strs( TUI_BASE *basep, char *text, char *mask, char *template );

/*------------------------- Prototypes for T_HELP.C ------------------------*/
tui_help( int sx, int sy, int ex, int ey, char *fname, char *search_str, int mode );
int browse( TUI_HELP *help );
void cleanup( TUI_HELP *help );
void remove_commands(char *s, char *d);
char *itoa4( int val );
get_line(int fid, uchar *d, int max_len);
find_color(char *s);
char *get_token( char *s, char *d, char delim, int mode );
int find_word( char *word, int curr_col, int *col, char *lines[], int num_lines, int dir, int mode );
int fast_find( char *word, char *lines[], int num_lines, int skip_line );
char *mystrstr( char *s, char *w, int mode, int skip );
void mystrupr( char *s, char *d );
cvt_tabs_to_spaces( char *s, int *text_len, int tab_size );
void init_help_video();
get_screen_text(char *buffer, int max_len);
get_font( char *fname, int block );
int auto_repeat(ulong tm);

/*------------------------- Prototypes for T_INIT.C ------------------------*/
void default_font( int block );
init_tui_fonts( TUI *tuip );
init_tui( TUI *tuip );
void end_tui( TUI *tuip );

/*------------------------- Prototypes for T_ADD.C  ------------------------*/
void set_base_parms( TUI_BASE *basep, int type, int hot_key, int flags,
		 int transfer, int x_off, int y_off, int width, int height, int style );
add_dialog( TUI *tuip, uint flags, int x_off, int y_off, int width, int height,
						int att, int bdr_att, int style );
add_box( TUI *tuip, int hot_key, uint flags, int transfer, int x_off,
				 int y_off, int width, int height, int att, int style );
add_button( TUI *tuip, int hot_key, uint flags, int transfer, int x_off,
						int y_off, int width, int height, int style, int norm_att,
						int norm_f_att, int sel_att, int sel_f_att, int tab_color,
						int first_pos, char *text );
add_check( TUI *tuip, int hot_key, uint flags, int transfer, int x_off,
					 int y_off, int width, int height, int style, int norm_att,
					 int norm_f_att, int tab_color, int mark_pos, uchar mark_char,
					 int first_pos, char *text );
add_input( TUI *tuip, int hot_key, uint flags, int transfer, int x_off,
					 int y_off, int width, int height, int style, int norm_att,
					 int tab_color, uchar input_flags, char *text, char *mask,
					 char *template );
add_slider( TUI *tuip, uint flags, int transfer, int x_off, int y_off,
						int width, int height, int style, int arrow_att, int track_att,
						int grab_att, uchar *slider_chars );
add_icon( TUI *tuip, int hot_key, uint flags, int transfer, int x_off,
					int y_off, int width, int height, int style, int norm_att,
					int sel_att, int tab_color, uchar *images );
void set_tui_parenting( TUI *tuip );
set_base_parent( TUI *tuip, int inx );

/*------------------------- Prototypes for T_SAVE.C ------------------------*/
save_tui( TUI *tuip, char *fname );

/*------------------------- Prototypes for T_LOAD.C ------------------------*/
load_tui( TUI *tuip, char *fname );

/*------------------------- Prototypes for T_FSELT.C ------------------------*/
void register_fsel_tui( TUI *tuip );

/*------------------------- Prototypes for T_HELPT.C ------------------------*/
void register_help_tui( TUI *tuip );

/**** END OF FILE ****/
