/**************************************************************************
* This is the function prototype declaration for the mousedrv module:	  *
*									  *
* W A R N I N G : This module assumes mouse driver was installed using    *
* one of the following program: mouse.com or mouse.sys.			  *
*									  *
* This module can be compiled in any model (tiny..huge)			  *
*									  *
* Note that as the mouse driver is used asyncronically (i.e. interrupts)  *
* fail to call MouseInit() at the begining or even worse, call		  *
* MouseClose() in the end is an invitation for total system disaster!	  *
*									  *
*						Gershon Elber	Aug. 88	  *
**************************************************************************/

#ifndef  MOUSE_DRV_H					/* Define only once. */
#define  MOUSE_DRV_H

#define  BUFFER_SIZE 256		     /* Size of mouse events buffer. */

#ifndef  TRUE
#define  TRUE	-1
#define  FALSE  0
#endif

/* And finally the external routines prototypes: */

void MouseSetResolution(int Resolution);
int  MouseDetect(void);
char *MouseInit(int Sensitivity);
void MouseClose(void);
int  MouseQueryBuffer(void);
int  MouseQueryDataBuffer(int *X, int *Y, int *Buttons, int *OverRunError);
int  MouseGetBuffer(int *X, int *Y, int *Buttons);
void MouseFlushBuffer(void);
void MouseShowCursor(void);
void MouseHideCursor(void);
void MouseSetPosition(int X, int Y);

/* Two external integers defined Mouse Range (start from 0): */
extern int MSMouseXmax, MSMouseYmax;

#endif   /* MOUSE_DRV_H */
